/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.jwt.runtime.auth;

import io.quarkus.security.AuthenticationFailedException;
import io.quarkus.security.credential.Credential;
import io.quarkus.security.identity.AuthenticationRequestContext;
import io.quarkus.security.identity.IdentityProvider;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.request.AuthenticationRequest;
import io.quarkus.security.identity.request.TokenAuthenticationRequest;
import io.quarkus.security.runtime.QuarkusSecurityIdentity;
import io.quarkus.smallrye.jwt.runtime.auth.JsonWebTokenCredential;
import io.quarkus.smallrye.jwt.runtime.auth.SmallRyeJwtConfig;
import io.quarkus.vertx.http.runtime.security.HttpSecurityUtils;
import io.smallrye.jwt.auth.principal.JWTParser;
import io.smallrye.jwt.auth.principal.ParseException;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.subscription.UniEmitter;
import io.vertx.ext.web.RoutingContext;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.security.Principal;
import java.util.function.Consumer;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.eclipse.microprofile.jwt.JsonWebToken;
import org.jboss.logging.Logger;

@ApplicationScoped
public class MpJwtValidator
implements IdentityProvider<TokenAuthenticationRequest> {
    private static final Logger log = Logger.getLogger(MpJwtValidator.class);
    private static final String NONE = "NONE";
    final JWTParser parser;
    final boolean blockingAuthentication;

    public MpJwtValidator() {
        this.parser = null;
        this.blockingAuthentication = false;
    }

    @Inject
    public MpJwtValidator(JWTParser parser, SmallRyeJwtConfig config, @ConfigProperty(name="mp.jwt.verify.publickey.location", defaultValue="NONE") String mpJwtLocation, @ConfigProperty(name="mp.jwt.decrypt.key.location", defaultValue="NONE") String mpJwtDecryptKeyLocation) {
        this.parser = parser;
        this.blockingAuthentication = MpJwtValidator.useBlockingAuthentication(config, mpJwtLocation, mpJwtDecryptKeyLocation);
    }

    public Class<TokenAuthenticationRequest> getRequestType() {
        return TokenAuthenticationRequest.class;
    }

    public Uni<SecurityIdentity> authenticate(final TokenAuthenticationRequest request, AuthenticationRequestContext context) {
        if (!(request.getToken() instanceof JsonWebTokenCredential)) {
            return Uni.createFrom().nullItem();
        }
        if (!this.blockingAuthentication) {
            return Uni.createFrom().emitter((Consumer)new Consumer<UniEmitter<? super SecurityIdentity>>(){

                @Override
                public void accept(UniEmitter<? super SecurityIdentity> uniEmitter) {
                    try {
                        uniEmitter.complete((Object)MpJwtValidator.this.createSecurityIdentity(request));
                    }
                    catch (AuthenticationFailedException e) {
                        uniEmitter.fail((Throwable)e);
                    }
                }
            });
        }
        return context.runBlocking(() -> this.createSecurityIdentity(request));
    }

    private SecurityIdentity createSecurityIdentity(TokenAuthenticationRequest request) {
        try {
            JsonWebToken jwtPrincipal = this.parser.parse(request.getToken().getToken());
            QuarkusSecurityIdentity.Builder builder = QuarkusSecurityIdentity.builder().setPrincipal((Principal)jwtPrincipal).addCredential((Credential)request.getToken()).addRoles(jwtPrincipal.getGroups()).addAttribute("quarkus.user", (Object)jwtPrincipal);
            RoutingContext routingContext = HttpSecurityUtils.getRoutingContextAttribute((AuthenticationRequest)request);
            if (routingContext != null) {
                builder.addAttribute(RoutingContext.class.getName(), (Object)routingContext);
            }
            return builder.build();
        }
        catch (ParseException e) {
            log.debug((Object)"Authentication failed", (Throwable)e);
            throw new AuthenticationFailedException((Throwable)e);
        }
    }

    public boolean isBlockingAuthentication() {
        return this.blockingAuthentication;
    }

    private static boolean useBlockingAuthentication(SmallRyeJwtConfig config, String mpJwtLocation, String mpJwtDecryptKeyLocation) {
        if (config != null && config.blockingAuthentication().isPresent()) {
            return config.blockingAuthentication().get();
        }
        return MpJwtValidator.isNotLocalResource(mpJwtLocation) || MpJwtValidator.isNotLocalResource(mpJwtDecryptKeyLocation);
    }

    private static boolean isNotLocalResource(String location) {
        return location != null && location.startsWith("http");
    }
}

