/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.jwt.runtime.auth;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import io.quarkus.security.credential.TokenCredential;
import io.quarkus.security.identity.IdentityProviderManager;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.request.AuthenticationRequest;
import io.quarkus.security.identity.request.TokenAuthenticationRequest;
import io.quarkus.smallrye.jwt.runtime.auth.JsonWebTokenCredential;
import io.quarkus.smallrye.jwt.runtime.auth.SmallRyeJwtConfig;
import io.quarkus.vertx.core.runtime.context.VertxContextSafetyToggle;
import io.quarkus.vertx.http.runtime.security.ChallengeData;
import io.quarkus.vertx.http.runtime.security.HttpAuthenticationMechanism;
import io.quarkus.vertx.http.runtime.security.HttpCredentialTransport;
import io.quarkus.vertx.http.runtime.security.HttpSecurityUtils;
import io.smallrye.jwt.auth.AbstractBearerTokenExtractor;
import io.smallrye.jwt.auth.principal.JWTAuthContextInfo;
import io.smallrye.mutiny.Uni;
import io.vertx.core.Context;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpHeaders;
import io.vertx.ext.web.RoutingContext;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.jboss.logging.Logger;

@ApplicationScoped
public class JWTAuthMechanism
implements HttpAuthenticationMechanism {
    private static final Logger LOG = Logger.getLogger(JWTAuthMechanism.class);
    private static final String ERROR_MSG = "SmallRye JWT requires a safe (isolated) Vert.x sub-context for propagation of the '" + TokenCredential.class.getName() + "', but the current context hasn't been flagged as such.";
    protected static final String COOKIE_HEADER = "Cookie";
    protected static final String AUTHORIZATION_HEADER = "Authorization";
    public static final String BEARER = "Bearer";
    private final boolean propagateTokenCredentialWithDuplicatedCtx;
    @Inject
    JWTAuthContextInfo authContextInfo;
    private final boolean silent;

    public JWTAuthMechanism(SmallRyeJwtConfig config) {
        this.silent = config == null ? false : config.silent();
        this.propagateTokenCredentialWithDuplicatedCtx = Boolean.getBoolean("io.quarkus.smallrye.jwt.runtime.auth.JWTAuthMechanism.PROPAGATE_TOKEN_CREDENTIAL_WITH_DUPLICATED_CTX");
    }

    public Uni<SecurityIdentity> authenticate(RoutingContext context, IdentityProviderManager identityProviderManager) {
        String jwtToken = new VertxBearerTokenExtractor(this.authContextInfo, context).getBearerToken();
        if (jwtToken != null) {
            context.put(HttpAuthenticationMechanism.class.getName(), (Object)this);
            if (this.propagateTokenCredentialWithDuplicatedCtx) {
                VertxContextSafetyToggle.validateContextIfExists((String)ERROR_MSG, (String)ERROR_MSG);
                final Context ctx = Vertx.currentContext();
                JsonWebTokenCredential token = new JsonWebTokenCredential(jwtToken);
                ctx.putLocal((Object)TokenCredential.class.getName(), (Object)token);
                return identityProviderManager.authenticate(HttpSecurityUtils.setRoutingContextAttribute((AuthenticationRequest)new TokenAuthenticationRequest((TokenCredential)token), (RoutingContext)context)).invoke(new Runnable(){

                    @Override
                    public void run() {
                        ctx.removeLocal((Object)TokenCredential.class.getName());
                    }
                });
            }
            return identityProviderManager.authenticate(HttpSecurityUtils.setRoutingContextAttribute((AuthenticationRequest)new TokenAuthenticationRequest((TokenCredential)new JsonWebTokenCredential(jwtToken)), (RoutingContext)context));
        }
        LOG.debug((Object)"Bearer access token is not available");
        return Uni.createFrom().optional(Optional.empty());
    }

    public Uni<ChallengeData> getChallenge(RoutingContext context) {
        String authHeader;
        if (this.silent && (authHeader = context.request().headers().get((CharSequence)HttpHeaderNames.AUTHORIZATION)) == null) {
            return Uni.createFrom().optional(Optional.empty());
        }
        ChallengeData result = new ChallengeData(HttpResponseStatus.UNAUTHORIZED.code(), (CharSequence)HttpHeaderNames.WWW_AUTHENTICATE, BEARER);
        return Uni.createFrom().item((Object)result);
    }

    public Set<Class<? extends AuthenticationRequest>> getCredentialTypes() {
        return Collections.singleton(TokenAuthenticationRequest.class);
    }

    public Uni<HttpCredentialTransport> getCredentialTransport(RoutingContext context) {
        String tokenHeaderName = this.authContextInfo.getTokenHeader();
        if (COOKIE_HEADER.equals(tokenHeaderName)) {
            String tokenCookieName = this.authContextInfo.getTokenCookie();
            if (tokenCookieName == null) {
                tokenCookieName = BEARER;
            }
            return Uni.createFrom().item((Object)new HttpCredentialTransport(HttpCredentialTransport.Type.COOKIE, tokenCookieName));
        }
        if (AUTHORIZATION_HEADER.equals(tokenHeaderName)) {
            return Uni.createFrom().item((Object)new HttpCredentialTransport(HttpCredentialTransport.Type.AUTHORIZATION, BEARER));
        }
        return Uni.createFrom().item((Object)new HttpCredentialTransport(HttpCredentialTransport.Type.OTHER_HEADER, tokenHeaderName));
    }

    private static class VertxBearerTokenExtractor
    extends AbstractBearerTokenExtractor {
        private RoutingContext httpExchange;

        VertxBearerTokenExtractor(JWTAuthContextInfo authContextInfo, RoutingContext exchange) {
            super(authContextInfo);
            this.httpExchange = exchange;
        }

        protected String getHeaderValue(String headerName) {
            return this.httpExchange.request().headers().get(headerName);
        }

        protected String getCookieValue(String cookieName) {
            io.vertx.core.http.Cookie cookie;
            String cookieHeader = this.httpExchange.request().headers().get(HttpHeaders.COOKIE);
            if (cookieHeader != null && this.httpExchange.cookieCount() == 0) {
                Set nettyCookies = ServerCookieDecoder.STRICT.decode(cookieHeader);
                for (Cookie cookie2 : nettyCookies) {
                    if (!cookie2.name().equals(cookieName)) continue;
                    return cookie2.value();
                }
            }
            return (cookie = this.httpExchange.getCookie(cookieName)) != null ? cookie.getValue() : null;
        }
    }
}

