/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.faulttolerance.runtime.devui;

import io.quarkus.arc.Arc;
import io.quarkus.smallrye.faulttolerance.runtime.QuarkusFaultToleranceOperationProvider;
import io.smallrye.common.annotation.Blocking;
import io.smallrye.common.annotation.NonBlocking;
import io.smallrye.faulttolerance.api.ApplyFaultTolerance;
import io.smallrye.faulttolerance.api.ApplyGuard;
import io.smallrye.faulttolerance.api.AsynchronousNonBlocking;
import io.smallrye.faulttolerance.api.BeforeRetry;
import io.smallrye.faulttolerance.api.CircuitBreakerName;
import io.smallrye.faulttolerance.api.CustomBackoff;
import io.smallrye.faulttolerance.api.ExponentialBackoff;
import io.smallrye.faulttolerance.api.FibonacciBackoff;
import io.smallrye.faulttolerance.api.RateLimit;
import io.smallrye.faulttolerance.api.RetryWhen;
import io.smallrye.faulttolerance.config.FaultToleranceOperation;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Comparator;
import org.eclipse.microprofile.faulttolerance.Asynchronous;
import org.eclipse.microprofile.faulttolerance.Bulkhead;
import org.eclipse.microprofile.faulttolerance.CircuitBreaker;
import org.eclipse.microprofile.faulttolerance.Fallback;
import org.eclipse.microprofile.faulttolerance.Retry;
import org.eclipse.microprofile.faulttolerance.Timeout;

public class FaultToleranceJsonRpcService {
    public JsonArray getGuardedMethods() {
        QuarkusFaultToleranceOperationProvider provider = (QuarkusFaultToleranceOperationProvider)Arc.container().select(QuarkusFaultToleranceOperationProvider.class, new Annotation[0]).get();
        ArrayList operations = new ArrayList(provider.getOperationCache().values());
        operations.sort(Comparator.comparing(FaultToleranceOperation::getName));
        JsonArray result = new JsonArray();
        for (FaultToleranceOperation operation : operations) {
            operation.materialize();
            result.add((Object)this.convert(operation));
        }
        return result;
    }

    private JsonObject convert(FaultToleranceOperation operation) {
        JsonObject result = new JsonObject();
        result.put("beanClass", (Object)operation.getBeanClass().getName());
        result.put("method", (Object)operation.getMethodDescriptor().name);
        if (operation.hasApplyFaultTolerance()) {
            result.put(ApplyFaultTolerance.class.getSimpleName(), (Object)new JsonObject().put("value", (Object)operation.getApplyFaultTolerance().value()));
        }
        if (operation.hasApplyGuard()) {
            result.put(ApplyGuard.class.getSimpleName(), (Object)new JsonObject().put("value", (Object)operation.getApplyGuard().value()));
        }
        if (operation.hasAsynchronous()) {
            result.put(Asynchronous.class.getSimpleName(), (Object)new JsonObject());
        }
        if (operation.hasAsynchronousNonBlocking()) {
            result.put(AsynchronousNonBlocking.class.getSimpleName(), (Object)new JsonObject());
        }
        if (operation.hasBlocking()) {
            result.put(Blocking.class.getSimpleName(), (Object)new JsonObject());
        }
        if (operation.hasNonBlocking()) {
            result.put(NonBlocking.class.getSimpleName(), (Object)new JsonObject());
        }
        if (operation.hasBulkhead()) {
            result.put(Bulkhead.class.getSimpleName(), (Object)new JsonObject().put("value", (Object)operation.getBulkhead().value()).put("waitingTaskQueue", (Object)operation.getBulkhead().waitingTaskQueue()));
        }
        if (operation.hasCircuitBreaker()) {
            result.put(CircuitBreaker.class.getSimpleName(), (Object)new JsonObject().put("delay", (Object)operation.getCircuitBreaker().delay()).put("delayUnit", (Object)operation.getCircuitBreaker().delayUnit()).put("requestVolumeThreshold", (Object)operation.getCircuitBreaker().requestVolumeThreshold()).put("failureRatio", (Object)operation.getCircuitBreaker().failureRatio()).put("successThreshold", (Object)operation.getCircuitBreaker().successThreshold()).put("failOn", (Object)FaultToleranceJsonRpcService.convert(operation.getCircuitBreaker().failOn())).put("skipOn", (Object)FaultToleranceJsonRpcService.convert(operation.getCircuitBreaker().skipOn())));
        }
        if (operation.hasCircuitBreakerName()) {
            result.put(CircuitBreakerName.class.getSimpleName(), (Object)new JsonObject().put("value", (Object)operation.getCircuitBreakerName().value()));
        }
        if (operation.hasFallback()) {
            result.put(Fallback.class.getSimpleName(), (Object)new JsonObject().put("value", (Object)operation.getFallback().value().getName()).put("fallbackMethod", (Object)operation.getFallback().fallbackMethod()).put("applyOn", (Object)FaultToleranceJsonRpcService.convert(operation.getFallback().applyOn())).put("skipOn", (Object)FaultToleranceJsonRpcService.convert(operation.getFallback().skipOn())));
        }
        if (operation.hasRateLimit()) {
            result.put(RateLimit.class.getSimpleName(), (Object)new JsonObject().put("value", (Object)operation.getRateLimit().value()).put("window", (Object)operation.getRateLimit().window()).put("windowUnit", (Object)operation.getRateLimit().windowUnit()).put("minSpacing", (Object)operation.getRateLimit().minSpacing()).put("minSpacingUnit", (Object)operation.getRateLimit().minSpacingUnit()).put("type", (Object)operation.getRateLimit().type()));
        }
        if (operation.hasRetry()) {
            result.put(Retry.class.getSimpleName(), (Object)new JsonObject().put("maxRetries", (Object)operation.getRetry().maxRetries()).put("delay", (Object)operation.getRetry().delay()).put("delayUnit", (Object)operation.getRetry().delayUnit()).put("maxDuration", (Object)operation.getRetry().maxDuration()).put("maxDurationUnit", (Object)operation.getRetry().durationUnit()).put("jitter", (Object)operation.getRetry().jitter()).put("jitterUnit", (Object)operation.getRetry().jitterDelayUnit()).put("retryOn", (Object)FaultToleranceJsonRpcService.convert(operation.getRetry().retryOn())).put("abortOn", (Object)FaultToleranceJsonRpcService.convert(operation.getRetry().abortOn())));
        }
        if (operation.hasExponentialBackoff()) {
            result.put(ExponentialBackoff.class.getSimpleName(), (Object)new JsonObject().put("factor", (Object)operation.getExponentialBackoff().factor()).put("maxDelay", (Object)operation.getExponentialBackoff().maxDelay()).put("maxDelayUnit", (Object)operation.getExponentialBackoff().maxDelayUnit()));
        }
        if (operation.hasFibonacciBackoff()) {
            result.put(FibonacciBackoff.class.getSimpleName(), (Object)new JsonObject().put("maxDelay", (Object)operation.getFibonacciBackoff().maxDelay()).put("maxDelayUnit", (Object)operation.getFibonacciBackoff().maxDelayUnit()));
        }
        if (operation.hasCustomBackoff()) {
            result.put(CustomBackoff.class.getSimpleName(), (Object)new JsonObject().put("value", (Object)operation.getCustomBackoff().value().getName()));
        }
        if (operation.hasRetryWhen()) {
            result.put(RetryWhen.class.getSimpleName(), (Object)new JsonObject().put("result", (Object)operation.getRetryWhen().result().getName()).put("exception", (Object)operation.getRetryWhen().exception().getName()));
        }
        if (operation.hasBeforeRetry()) {
            result.put(BeforeRetry.class.getSimpleName(), (Object)new JsonObject().put("value", (Object)operation.getBeforeRetry().value().getName()).put("methodName", (Object)operation.getBeforeRetry().methodName()));
        }
        if (operation.hasTimeout()) {
            result.put(Timeout.class.getSimpleName(), (Object)new JsonObject().put("value", (Object)operation.getTimeout().value()).put("valueUnit", (Object)operation.getTimeout().unit()));
        }
        return result;
    }

    private static JsonArray convert(Class<?>[] classes) {
        JsonArray result = new JsonArray();
        for (Class<?> clazz : classes) {
            result.add((Object)clazz.getName());
        }
        return result;
    }
}

