/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.faulttolerance.deployment;

import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.execannotations.ExecutionModelAnnotationsAllowedBuildItem;
import io.quarkus.smallrye.faulttolerance.deployment.DotNames;
import java.util.Set;
import java.util.function.Predicate;
import org.jboss.jandex.MethodInfo;

public class FaultToleranceMethodsProcessor {
    @BuildStep
    ExecutionModelAnnotationsAllowedBuildItem eventConsumerMethods() {
        return new ExecutionModelAnnotationsAllowedBuildItem((Predicate)new Predicate<MethodInfo>(){

            @Override
            public boolean test(MethodInfo method) {
                Set classAnnotations = method.declaringClass().annotationsMap().keySet();
                return classAnnotations.contains(DotNames.ASYNCHRONOUS) || classAnnotations.contains(DotNames.BULKHEAD) || classAnnotations.contains(DotNames.CIRCUIT_BREAKER) || classAnnotations.contains(DotNames.FALLBACK) || classAnnotations.contains(DotNames.RATE_LIMIT) || classAnnotations.contains(DotNames.RETRY) || classAnnotations.contains(DotNames.TIMEOUT);
            }
        });
    }
}

