/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.runtime;

import io.quarkus.security.AuthenticationFailedException;
import io.quarkus.security.identity.AuthenticationRequestContext;
import io.quarkus.security.identity.IdentityProvider;
import io.quarkus.security.identity.IdentityProviderManager;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.SecurityIdentityAugmentor;
import io.quarkus.security.identity.request.AnonymousAuthenticationRequest;
import io.quarkus.security.identity.request.AuthenticationRequest;
import io.quarkus.security.runtime.QuarkusPermissionSecurityIdentityAugmentor;
import io.quarkus.security.spi.runtime.BlockingSecurityExecutor;
import io.smallrye.mutiny.Uni;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jboss.logging.Logger;

public class QuarkusIdentityProviderManagerImpl
implements IdentityProviderManager {
    private static final Logger log = Logger.getLogger(QuarkusIdentityProviderManagerImpl.class);
    private final Map<Class<? extends AuthenticationRequest>, List<IdentityProvider<? extends AuthenticationRequest>>> providers;
    private final SecurityIdentityAugmentor[] augmenters;
    private final AuthenticationRequestContext blockingRequestContext;

    QuarkusIdentityProviderManagerImpl(final Builder builder) {
        this.providers = builder.providers;
        this.augmenters = (SecurityIdentityAugmentor[])builder.augmentors.toArray(SecurityIdentityAugmentor[]::new);
        this.blockingRequestContext = new AuthenticationRequestContext(){

            public Uni<SecurityIdentity> runBlocking(Supplier<SecurityIdentity> function) {
                return builder.blockingExecutor.executeBlocking(function);
            }
        };
    }

    public Uni<SecurityIdentity> authenticate(AuthenticationRequest request) {
        try {
            List<IdentityProvider<? extends AuthenticationRequest>> providers = this.providers.get(request.getClass());
            if (providers == null) {
                return Uni.createFrom().failure((Throwable)new IllegalArgumentException("No IdentityProviders were registered to handle AuthenticationRequest " + String.valueOf(request)));
            }
            if (providers.size() == 1) {
                return this.handleSingleProvider(QuarkusIdentityProviderManagerImpl.getProvider(0, request, providers), request);
            }
            return this.handleProviders(providers, request);
        }
        catch (Throwable t) {
            return Uni.createFrom().failure(t);
        }
    }

    private <T extends AuthenticationRequest> Uni<SecurityIdentity> handleSingleProvider(IdentityProvider<T> identityProvider, final T request) {
        Uni authenticated = identityProvider.authenticate(request, this.blockingRequestContext).onItem().ifNull().failWith((Supplier)new Supplier<Throwable>(){

            @Override
            public Throwable get() {
                return new AuthenticationFailedException();
            }
        });
        if (this.augmenters.length > 0) {
            authenticated = authenticated.flatMap((Function)new Function<SecurityIdentity, Uni<? extends SecurityIdentity>>(){

                @Override
                public Uni<? extends SecurityIdentity> apply(SecurityIdentity securityIdentity) {
                    return QuarkusIdentityProviderManagerImpl.this.handleIdentityFromProvider(0, securityIdentity, request.getAttributes());
                }
            });
        }
        return authenticated;
    }

    public SecurityIdentity authenticateBlocking(AuthenticationRequest request) {
        List<IdentityProvider<? extends AuthenticationRequest>> providers = this.providers.get(request.getClass());
        if (providers == null) {
            throw new IllegalArgumentException("No IdentityProviders were registered to handle AuthenticationRequest " + String.valueOf(request));
        }
        return (SecurityIdentity)this.handleProviders(providers, request).await().indefinitely();
    }

    private Uni<SecurityIdentity> handleProviders(List<IdentityProvider<? extends AuthenticationRequest>> providers, final AuthenticationRequest request) {
        return this.handleProvider(0, providers, request).onItem().transformToUni((Function)new Function<SecurityIdentity, Uni<? extends SecurityIdentity>>(){

            @Override
            public Uni<? extends SecurityIdentity> apply(SecurityIdentity securityIdentity) {
                return QuarkusIdentityProviderManagerImpl.this.handleIdentityFromProvider(0, securityIdentity, request.getAttributes());
            }
        });
    }

    private Uni<SecurityIdentity> handleProvider(final int pos, final List<IdentityProvider<? extends AuthenticationRequest>> providers, final AuthenticationRequest request) {
        if (pos == providers.size()) {
            log.debug((Object)"Authentication failed as providers would authenticate the request");
            return Uni.createFrom().failure((Throwable)new AuthenticationFailedException());
        }
        return QuarkusIdentityProviderManagerImpl.getProvider(pos, request, providers).authenticate(request, this.blockingRequestContext).onItem().transformToUni((Function)new Function<SecurityIdentity, Uni<? extends SecurityIdentity>>(){

            @Override
            public Uni<SecurityIdentity> apply(SecurityIdentity securityIdentity) {
                if (securityIdentity != null) {
                    return Uni.createFrom().item((Object)securityIdentity);
                }
                return QuarkusIdentityProviderManagerImpl.this.handleProvider(pos + 1, providers, request);
            }
        });
    }

    private Uni<SecurityIdentity> handleIdentityFromProvider(final int pos, SecurityIdentity identity, final Map<String, Object> attributes) {
        if (pos == this.augmenters.length) {
            return Uni.createFrom().item((Object)identity);
        }
        SecurityIdentityAugmentor a = this.augmenters[pos];
        return a.augment(identity, this.blockingRequestContext, attributes).flatMap((Function)new Function<SecurityIdentity, Uni<? extends SecurityIdentity>>(){

            @Override
            public Uni<SecurityIdentity> apply(SecurityIdentity securityIdentity) {
                return QuarkusIdentityProviderManagerImpl.this.handleIdentityFromProvider(pos + 1, securityIdentity, attributes);
            }
        });
    }

    private static <T extends AuthenticationRequest> IdentityProvider<T> getProvider(int pos, T ignored, List<IdentityProvider<? extends AuthenticationRequest>> providers) {
        return providers.get(pos);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final Map<Class<? extends AuthenticationRequest>, List<IdentityProvider<? extends AuthenticationRequest>>> providers = new HashMap<Class<? extends AuthenticationRequest>, List<IdentityProvider<? extends AuthenticationRequest>>>();
        private final List<SecurityIdentityAugmentor> augmentors = new ArrayList<SecurityIdentityAugmentor>();
        private QuarkusPermissionSecurityIdentityAugmentor quarkusPermissionAugmentor = null;
        private BlockingSecurityExecutor blockingExecutor;
        private boolean built = false;

        Builder() {
        }

        public Builder addProvider(IdentityProvider<? extends AuthenticationRequest> provider) {
            if (this.built) {
                throw new IllegalStateException("manager has already been built");
            }
            this.providers.computeIfAbsent(provider.getRequestType(), a -> new ArrayList()).add(provider);
            return this;
        }

        public Builder addSecurityIdentityAugmentor(SecurityIdentityAugmentor augmentor) {
            if (augmentor instanceof QuarkusPermissionSecurityIdentityAugmentor) {
                QuarkusPermissionSecurityIdentityAugmentor quarkusPermissionAugmentor;
                this.quarkusPermissionAugmentor = quarkusPermissionAugmentor = (QuarkusPermissionSecurityIdentityAugmentor)augmentor;
            } else {
                this.augmentors.add(augmentor);
            }
            return this;
        }

        public Builder setBlockingExecutor(BlockingSecurityExecutor blockingExecutor) {
            this.blockingExecutor = blockingExecutor;
            return this;
        }

        public Builder setBlockingExecutor(Executor blockingExecutor) {
            this.blockingExecutor = BlockingSecurityExecutor.createBlockingExecutor(() -> blockingExecutor);
            return this;
        }

        public QuarkusIdentityProviderManagerImpl build() {
            this.built = true;
            if (!this.providers.containsKey(AnonymousAuthenticationRequest.class)) {
                throw new IllegalStateException("No AnonymousIdentityProvider registered. An instance of AnonymousIdentityProvider must be provided to allow the Anonymous identity to be created.");
            }
            for (List<IdentityProvider<? extends AuthenticationRequest>> providers : this.providers.values()) {
                providers.sort(new Comparator<IdentityProvider<? extends AuthenticationRequest>>(){

                    @Override
                    public int compare(IdentityProvider o1, IdentityProvider o2) {
                        return Integer.compare(o2.priority(), o1.priority());
                    }
                });
            }
            if (this.blockingExecutor == null) {
                throw new IllegalStateException("no blocking executor specified");
            }
            this.augmentors.sort(new Comparator<SecurityIdentityAugmentor>(){

                @Override
                public int compare(SecurityIdentityAugmentor o1, SecurityIdentityAugmentor o2) {
                    return Integer.compare(o2.priority(), o1.priority());
                }
            });
            if (this.quarkusPermissionAugmentor != null) {
                this.augmentors.add(this.quarkusPermissionAugmentor);
            }
            return new QuarkusIdentityProviderManagerImpl(this);
        }
    }
}

