/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.runtime;

import io.quarkus.runtime.BlockingOperationControl;
import io.quarkus.security.AuthenticationFailedException;
import io.quarkus.security.identity.AuthenticationRequestContext;
import io.quarkus.security.identity.IdentityProvider;
import io.quarkus.security.identity.IdentityProviderManager;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.SecurityIdentityAugmentor;
import io.quarkus.security.identity.request.AnonymousAuthenticationRequest;
import io.quarkus.security.identity.request.AuthenticationRequest;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.subscription.UniEmitter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jboss.logging.Logger;

public class QuarkusIdentityProviderManagerImpl
implements IdentityProviderManager {
    private static final Logger log = Logger.getLogger(QuarkusIdentityProviderManagerImpl.class);
    private final Map<Class<? extends AuthenticationRequest>, List<IdentityProvider>> providers;
    private final List<SecurityIdentityAugmentor> augmenters;
    private final Executor blockingExecutor;
    private final AuthenticationRequestContext blockingRequestContext = new AuthenticationRequestContext(){

        public Uni<SecurityIdentity> runBlocking(final Supplier<SecurityIdentity> function) {
            return Uni.createFrom().deferred((Supplier)new Supplier<Uni<? extends SecurityIdentity>>(){

                @Override
                public Uni<SecurityIdentity> get() {
                    if (BlockingOperationControl.isBlockingAllowed()) {
                        try {
                            SecurityIdentity result = (SecurityIdentity)function.get();
                            return Uni.createFrom().item((Object)result);
                        }
                        catch (Throwable t) {
                            return Uni.createFrom().failure(t);
                        }
                    }
                    return Uni.createFrom().emitter((Consumer)new Consumer<UniEmitter<? super SecurityIdentity>>(){

                        @Override
                        public void accept(final UniEmitter<? super SecurityIdentity> uniEmitter) {
                            QuarkusIdentityProviderManagerImpl.this.blockingExecutor.execute(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        uniEmitter.complete(function.get());
                                    }
                                    catch (Throwable t) {
                                        uniEmitter.fail(t);
                                    }
                                }
                            });
                        }
                    });
                }
            });
        }
    };

    QuarkusIdentityProviderManagerImpl(Builder builder) {
        this.providers = builder.providers;
        this.augmenters = builder.augmentors;
        this.blockingExecutor = builder.blockingExecutor;
    }

    public Uni<SecurityIdentity> authenticate(AuthenticationRequest request) {
        try {
            List providers = this.providers.get(request.getClass());
            if (providers == null) {
                return Uni.createFrom().failure((Throwable)new IllegalArgumentException("No IdentityProviders were registered to handle AuthenticationRequest " + request));
            }
            if (providers.size() == 1) {
                return this.handleSingleProvider(providers.get(0), request);
            }
            return this.handleProvider(0, providers, request, this.blockingRequestContext);
        }
        catch (Throwable t) {
            return Uni.createFrom().failure(t);
        }
    }

    private Uni<SecurityIdentity> handleSingleProvider(IdentityProvider identityProvider, AuthenticationRequest request) {
        if (this.augmenters.isEmpty()) {
            return identityProvider.authenticate(request, this.blockingRequestContext);
        }
        Uni authenticated = identityProvider.authenticate(request, this.blockingRequestContext);
        return authenticated.flatMap((Function)new Function<SecurityIdentity, Uni<? extends SecurityIdentity>>(){

            @Override
            public Uni<? extends SecurityIdentity> apply(SecurityIdentity securityIdentity) {
                return QuarkusIdentityProviderManagerImpl.this.handleIdentityFromProvider(0, securityIdentity, QuarkusIdentityProviderManagerImpl.this.blockingRequestContext);
            }
        });
    }

    public SecurityIdentity authenticateBlocking(AuthenticationRequest request) {
        List providers = this.providers.get(request.getClass());
        if (providers == null) {
            throw new IllegalArgumentException("No IdentityProviders were registered to handle AuthenticationRequest " + request);
        }
        return (SecurityIdentity)this.handleProvider(0, providers, request, this.blockingRequestContext).await().indefinitely();
    }

    private <T extends AuthenticationRequest> Uni<SecurityIdentity> handleProvider(final int pos, final List<IdentityProvider<T>> providers, final T request, final AuthenticationRequestContext context) {
        if (pos == providers.size()) {
            log.debug((Object)"Authentication failed as providers would authenticate the request");
            return Uni.createFrom().failure((Throwable)new AuthenticationFailedException());
        }
        IdentityProvider<T> current = providers.get(pos);
        Uni cs = current.authenticate(request, context).onItem().transformToUni((Function)new Function<SecurityIdentity, Uni<? extends SecurityIdentity>>(){

            @Override
            public Uni<SecurityIdentity> apply(SecurityIdentity securityIdentity) {
                if (securityIdentity != null) {
                    return Uni.createFrom().item((Object)securityIdentity);
                }
                return QuarkusIdentityProviderManagerImpl.this.handleProvider(pos + 1, providers, request, context);
            }
        });
        return cs.onItem().transformToUni((Function)new Function<SecurityIdentity, Uni<? extends SecurityIdentity>>(){

            @Override
            public Uni<? extends SecurityIdentity> apply(SecurityIdentity securityIdentity) {
                return QuarkusIdentityProviderManagerImpl.this.handleIdentityFromProvider(0, securityIdentity, context);
            }
        });
    }

    private Uni<SecurityIdentity> handleIdentityFromProvider(final int pos, SecurityIdentity identity, final AuthenticationRequestContext context) {
        if (pos == this.augmenters.size()) {
            return Uni.createFrom().item((Object)identity);
        }
        SecurityIdentityAugmentor a = this.augmenters.get(pos);
        return a.augment(identity, context).flatMap((Function)new Function<SecurityIdentity, Uni<? extends SecurityIdentity>>(){

            @Override
            public Uni<SecurityIdentity> apply(SecurityIdentity securityIdentity) {
                return QuarkusIdentityProviderManagerImpl.this.handleIdentityFromProvider(pos + 1, securityIdentity, context);
            }
        });
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final Map<Class<? extends AuthenticationRequest>, List<IdentityProvider>> providers = new HashMap<Class<? extends AuthenticationRequest>, List<IdentityProvider>>();
        private final List<SecurityIdentityAugmentor> augmentors = new ArrayList<SecurityIdentityAugmentor>();
        private Executor blockingExecutor;
        private boolean built = false;

        Builder() {
        }

        public Builder addProvider(IdentityProvider provider) {
            if (this.built) {
                throw new IllegalStateException("manager has already been built");
            }
            this.providers.computeIfAbsent(provider.getRequestType(), a -> new ArrayList()).add(provider);
            return this;
        }

        public Builder addSecurityIdentityAugmentor(SecurityIdentityAugmentor augmentor) {
            this.augmentors.add(augmentor);
            return this;
        }

        public Builder setBlockingExecutor(Executor blockingExecutor) {
            this.blockingExecutor = blockingExecutor;
            return this;
        }

        public QuarkusIdentityProviderManagerImpl build() {
            this.built = true;
            if (!this.providers.containsKey(AnonymousAuthenticationRequest.class)) {
                throw new IllegalStateException("No AnonymousIdentityProvider registered. An instance of AnonymousIdentityProvider must be provided to allow the Anonymous identity to be created.");
            }
            if (this.blockingExecutor == null) {
                throw new IllegalStateException("no blocking executor specified");
            }
            this.augmentors.sort(new Comparator<SecurityIdentityAugmentor>(){

                @Override
                public int compare(SecurityIdentityAugmentor o1, SecurityIdentityAugmentor o2) {
                    return Integer.compare(o2.priority(), o1.priority());
                }
            });
            return new QuarkusIdentityProviderManagerImpl(this);
        }
    }
}

