/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.spi;

import io.quarkus.builder.item.SimpleBuildItem;
import java.util.List;
import java.util.Optional;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;

public final class PermissionsAllowedMetaAnnotationBuildItem
extends SimpleBuildItem {
    private final List<DotName> metaAnnotationNames;
    private final boolean empty;
    private final List<AnnotationInstance> transitiveInstances;

    public PermissionsAllowedMetaAnnotationBuildItem(List<AnnotationInstance> transitiveInstances, List<DotName> metaAnnotationNames) {
        this.transitiveInstances = List.copyOf(transitiveInstances);
        this.metaAnnotationNames = List.copyOf(metaAnnotationNames);
        this.empty = transitiveInstances.isEmpty();
    }

    public boolean hasPermissionsAllowed(MethodInfo methodInfo) {
        if (this.empty) {
            return false;
        }
        return this.hasPermissionsAllowed(methodInfo.annotations());
    }

    public boolean hasPermissionsAllowed(ClassInfo classInfo) {
        if (this.empty) {
            return false;
        }
        return this.hasPermissionsAllowed(classInfo.declaredAnnotations());
    }

    public List<AnnotationInstance> getTransitiveInstances() {
        return this.transitiveInstances;
    }

    private boolean hasPermissionsAllowed(List<AnnotationInstance> instances) {
        return instances.stream().anyMatch(ai -> this.metaAnnotationNames.contains(ai.name()));
    }

    public Optional<AnnotationInstance> findPermissionsAllowedInstance(ClassInfo classInfo) {
        if (this.empty) {
            return Optional.empty();
        }
        return this.transitiveInstances.stream().filter(ai -> ai.target().kind() == AnnotationTarget.Kind.CLASS).filter(ai -> ai.target().asClass().name().equals((Object)classInfo.name())).findFirst();
    }
}

