/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.scheduler.common.runtime;

import com.cronutils.model.CronType;
import io.quarkus.scheduler.Scheduled;
import io.quarkus.scheduler.common.runtime.ScheduledInvoker;
import io.quarkus.scheduler.common.runtime.ScheduledMethod;
import java.lang.reflect.InvocationTargetException;
import java.util.List;

public interface SchedulerContext {
    public CronType getCronType();

    public List<ScheduledMethod> getScheduledMethods();

    public boolean forceSchedulerStart();

    public List<ScheduledMethod> getScheduledMethods(String var1);

    public boolean matchesImplementation(Scheduled var1, String var2);

    public String autoImplementation();

    default public ScheduledInvoker createInvoker(String invokerClassName) {
        try {
            Class<?> invokerClazz = Thread.currentThread().getContextClassLoader().loadClass(invokerClassName);
            return (ScheduledInvoker)invokerClazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("Unable to create invoker: " + invokerClassName, e);
        }
    }
}

