/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.runtime.security;

import io.quarkus.arc.Arc;
import io.quarkus.arc.InjectableInstance;
import io.quarkus.resteasy.reactive.server.runtime.StandardSecurityCheckInterceptor;
import io.quarkus.resteasy.reactive.server.runtime.security.SecurityEventContext;
import io.quarkus.security.UnauthorizedException;
import io.quarkus.security.identity.CurrentIdentityAssociation;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.spi.runtime.AuthorizationController;
import io.quarkus.security.spi.runtime.AuthorizationFailureEvent;
import io.quarkus.security.spi.runtime.AuthorizationSuccessEvent;
import io.quarkus.security.spi.runtime.MethodDescription;
import io.quarkus.security.spi.runtime.SecurityCheck;
import io.quarkus.security.spi.runtime.SecurityCheckStorage;
import io.quarkus.security.spi.runtime.SecurityEvent;
import io.quarkus.security.spi.runtime.SecurityEventHelper;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.subscription.UniSubscriber;
import io.smallrye.mutiny.subscription.UniSubscription;
import io.vertx.ext.web.RoutingContext;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jboss.resteasy.reactive.common.model.ResourceClass;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.model.HandlerChainCustomizer;
import org.jboss.resteasy.reactive.server.model.ServerResourceMethod;
import org.jboss.resteasy.reactive.server.spi.ResteasyReactiveResourceInfo;
import org.jboss.resteasy.reactive.server.spi.ServerRestHandler;

public class EagerSecurityHandler
implements ServerRestHandler {
    private static final SecurityCheck NULL_SENTINEL = new SecurityCheck(){

        public void apply(SecurityIdentity identity, Method method, Object[] parameters) {
        }

        public void apply(SecurityIdentity identity, MethodDescription method, Object[] parameters) {
        }
    };
    private final boolean isProactiveAuthDisabled;
    private volatile InjectableInstance<CurrentIdentityAssociation> currentIdentityAssociation;
    private volatile SecurityCheck check;
    private volatile SecurityEventHelper<AuthorizationSuccessEvent, AuthorizationFailureEvent> securityEventHelper;
    private volatile AuthorizationController authorizationController;

    public EagerSecurityHandler(boolean isProactiveAuthDisabled) {
        this.isProactiveAuthDisabled = isProactiveAuthDisabled;
    }

    public void handle(final ResteasyReactiveRequestContext requestContext) throws Exception {
        if (this.check == NULL_SENTINEL) {
            return;
        }
        SecurityCheck check = this.check;
        ResteasyReactiveResourceInfo lazyMethod = requestContext.getTarget().getLazyMethod();
        final MethodDescription methodDescription = EagerSecurityHandler.lazyMethodToMethodDescription(lazyMethod);
        if (check == null) {
            SecurityCheckStorage storage = (SecurityCheckStorage)Arc.container().instance(SecurityCheckStorage.class, new Annotation[0]).get();
            check = storage.getSecurityCheck(methodDescription);
            if (check == null) {
                check = storage.getDefaultSecurityCheck() == null || this.isRequestAlreadyChecked(requestContext) ? NULL_SENTINEL : storage.getDefaultSecurityCheck();
            }
            this.check = check;
        }
        if (check == NULL_SENTINEL) {
            return;
        }
        if (this.authorizationController == null) {
            this.authorizationController = (AuthorizationController)Arc.container().instance(AuthorizationController.class, new Annotation[0]).get();
        }
        if (!this.authorizationController.isAuthorizationEnabled()) {
            return;
        }
        requestContext.requireCDIRequestScope();
        final SecurityCheck theCheck = check;
        if (theCheck.isPermitAll()) {
            this.preventRepeatedSecurityChecks(requestContext, methodDescription);
            if (this.getSecurityEventHelper().fireEventOnSuccess()) {
                this.getSecurityEventHelper().fireSuccessEvent((SecurityEvent)new AuthorizationSuccessEvent(null, theCheck.getClass().getName(), EagerSecurityHandler.createEventPropsWithRoutingCtx(requestContext)));
            }
        } else {
            requestContext.suspend();
            Uni deferredIdentity = ((CurrentIdentityAssociation)this.getCurrentIdentityAssociation().get()).getDeferredIdentity();
            if (this.isProactiveAuthDisabled && lazyMethod.isNonBlocking) {
                deferredIdentity = deferredIdentity.call(securityIdentity -> {
                    if (securityIdentity != null) {
                        ((CurrentIdentityAssociation)this.getCurrentIdentityAssociation().get()).setIdentity(securityIdentity);
                    }
                    return Uni.createFrom().item(securityIdentity);
                });
            }
            deferredIdentity.flatMap(new Function<SecurityIdentity, Uni<?>>(){

                @Override
                public Uni<?> apply(final SecurityIdentity securityIdentity) {
                    if (theCheck.requiresMethodArguments()) {
                        if (securityIdentity.isAnonymous()) {
                            UnauthorizedException unauthorizedException = new UnauthorizedException();
                            if (EagerSecurityHandler.this.getSecurityEventHelper().fireEventOnFailure()) {
                                EagerSecurityHandler.this.getSecurityEventHelper().fireFailureEvent((SecurityEvent)new AuthorizationFailureEvent(securityIdentity, (Throwable)unauthorizedException, theCheck.getClass().getName(), EagerSecurityHandler.createEventPropsWithRoutingCtx(requestContext)));
                            }
                            throw unauthorizedException;
                        }
                        return Uni.createFrom().nullItem();
                    }
                    EagerSecurityHandler.this.preventRepeatedSecurityChecks(requestContext, methodDescription);
                    Uni checkResult = theCheck.nonBlockingApply(securityIdentity, methodDescription, requestContext.getParameters());
                    if (EagerSecurityHandler.this.getSecurityEventHelper().fireEventOnFailure()) {
                        checkResult = checkResult.onFailure().invoke((Consumer)new Consumer<Throwable>(){

                            @Override
                            public void accept(Throwable throwable) {
                                EagerSecurityHandler.this.getSecurityEventHelper().fireFailureEvent((SecurityEvent)new AuthorizationFailureEvent(securityIdentity, throwable, theCheck.getClass().getName(), EagerSecurityHandler.createEventPropsWithRoutingCtx(requestContext)));
                            }
                        });
                    }
                    if (EagerSecurityHandler.this.getSecurityEventHelper().fireEventOnSuccess()) {
                        checkResult = checkResult.invoke(new Runnable(){

                            @Override
                            public void run() {
                                EagerSecurityHandler.this.getSecurityEventHelper().fireSuccessEvent((SecurityEvent)new AuthorizationSuccessEvent(securityIdentity, theCheck.getClass().getName(), EagerSecurityHandler.createEventPropsWithRoutingCtx(requestContext)));
                            }
                        });
                    }
                    return checkResult;
                }
            }).subscribe().withSubscriber((UniSubscriber)new UniSubscriber<Object>(){

                public void onSubscribe(UniSubscription subscription) {
                }

                public void onItem(Object item) {
                    requestContext.resume();
                }

                public void onFailure(Throwable failure) {
                    requestContext.resume(failure, true);
                }
            });
        }
    }

    private static Map<String, Object> createEventPropsWithRoutingCtx(ResteasyReactiveRequestContext requestContext) {
        RoutingContext routingContext = (RoutingContext)requestContext.unwrap(RoutingContext.class);
        if (routingContext == null) {
            return Map.of();
        }
        return Map.of(RoutingContext.class.getName(), routingContext);
    }

    static MethodDescription lazyMethodToMethodDescription(ResteasyReactiveResourceInfo lazyMethod) {
        return new MethodDescription(lazyMethod.getActualDeclaringClassName(), lazyMethod.getName(), MethodDescription.typesAsStrings((Class[])lazyMethod.getParameterTypes()));
    }

    private void preventRepeatedSecurityChecks(ResteasyReactiveRequestContext requestContext, MethodDescription methodDescription) {
        requestContext.setProperty(StandardSecurityCheckInterceptor.STANDARD_SECURITY_CHECK_INTERCEPTOR, (Object)methodDescription);
    }

    private boolean isRequestAlreadyChecked(ResteasyReactiveRequestContext requestContext) {
        return requestContext.getProperty(StandardSecurityCheckInterceptor.STANDARD_SECURITY_CHECK_INTERCEPTOR) != null;
    }

    private InjectableInstance<CurrentIdentityAssociation> getCurrentIdentityAssociation() {
        InjectableInstance<CurrentIdentityAssociation> identityAssociation = this.currentIdentityAssociation;
        if (identityAssociation == null) {
            this.currentIdentityAssociation = Arc.container().select(CurrentIdentityAssociation.class, new Annotation[0]);
            return this.currentIdentityAssociation;
        }
        return identityAssociation;
    }

    private SecurityEventHelper<AuthorizationSuccessEvent, AuthorizationFailureEvent> getSecurityEventHelper() {
        if (this.securityEventHelper == null) {
            this.securityEventHelper = ((SecurityEventContext)Arc.container().instance(SecurityEventContext.class, new Annotation[0]).get()).getHelper();
        }
        return this.securityEventHelper;
    }

    public static abstract class Customizer
    implements HandlerChainCustomizer {
        public static HandlerChainCustomizer newInstance(boolean isProactiveAuthEnabled) {
            return isProactiveAuthEnabled ? new ProactiveAuthEnabledCustomizer() : new ProactiveAuthDisabledCustomizer();
        }

        protected abstract boolean isProactiveAuthDisabled();

        public List<ServerRestHandler> handlers(HandlerChainCustomizer.Phase phase, ResourceClass resourceClass, ServerResourceMethod serverResourceMethod) {
            if (phase == HandlerChainCustomizer.Phase.AFTER_MATCH) {
                return Collections.singletonList(new EagerSecurityHandler(this.isProactiveAuthDisabled()));
            }
            return Collections.emptyList();
        }

        public static class ProactiveAuthEnabledCustomizer
        extends Customizer {
            @Override
            protected boolean isProactiveAuthDisabled() {
                return false;
            }
        }

        public static class ProactiveAuthDisabledCustomizer
        extends Customizer {
            @Override
            protected boolean isProactiveAuthDisabled() {
                return true;
            }
        }
    }
}

