/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.jackson.runtime.security;

import com.fasterxml.jackson.databind.ser.PropertyWriter;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.resteasy.reactive.jackson.SecureField;
import io.quarkus.resteasy.reactive.jackson.runtime.security.RolesAllowedConfigExpStorage;
import io.quarkus.security.identity.SecurityIdentity;
import java.lang.annotation.Annotation;

public class SecurityPropertyFilter
extends SimpleBeanPropertyFilter {
    static final String FILTER_ID = "securityFilter";
    private volatile InstanceHandle<RolesAllowedConfigExpStorage> rolesAllowedConfigExpStorage;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RolesAllowedConfigExpStorage getRolesAllowedConfigExpStorage(ArcContainer container) {
        if (this.rolesAllowedConfigExpStorage == null) {
            SecurityPropertyFilter securityPropertyFilter = this;
            synchronized (securityPropertyFilter) {
                if (this.rolesAllowedConfigExpStorage == null) {
                    this.rolesAllowedConfigExpStorage = container.instance(RolesAllowedConfigExpStorage.class, new Annotation[0]);
                }
            }
        }
        if (this.rolesAllowedConfigExpStorage.isAvailable()) {
            return (RolesAllowedConfigExpStorage)this.rolesAllowedConfigExpStorage.get();
        }
        return null;
    }

    protected boolean include(PropertyWriter writer) {
        SecureField secureField = (SecureField)writer.getAnnotation(SecureField.class);
        if (secureField == null) {
            return super.include(writer);
        }
        ArcContainer container = Arc.container();
        if (container == null) {
            return false;
        }
        InstanceHandle instance = container.instance(SecurityIdentity.class, new Annotation[0]);
        if (!instance.isAvailable()) {
            return false;
        }
        SecurityIdentity securityIdentity = (SecurityIdentity)instance.get();
        RolesAllowedConfigExpStorage rolesConfigExpStorage = this.getRolesAllowedConfigExpStorage(container);
        for (String role : secureField.rolesAllowed()) {
            String[] roles;
            if (rolesConfigExpStorage != null && (roles = rolesConfigExpStorage.getRoles(role)) != null) {
                for (String r : roles) {
                    if (!securityIdentity.hasRole(r)) continue;
                    return true;
                }
                continue;
            }
            if (!securityIdentity.hasRole(role)) continue;
            return true;
        }
        return false;
    }
}

