/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.runtime;

import io.quarkus.resteasy.reactive.server.runtime.ResteasyReactiveRecorder;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.container.CompletionCallback;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.common.providers.serialisers.FileBodyHandler;
import org.jboss.resteasy.reactive.server.spi.ResteasyReactiveResourceInfo;
import org.jboss.resteasy.reactive.server.spi.RuntimeConfiguration;
import org.jboss.resteasy.reactive.server.spi.ServerMessageBodyReader;
import org.jboss.resteasy.reactive.server.spi.ServerRequestContext;

public class QuarkusServerPathBodyHandler
implements ServerMessageBodyReader<Path> {
    private static final Logger log = Logger.getLogger(QuarkusServerPathBodyHandler.class);

    public boolean isReadable(Class<?> type, Type genericType, ResteasyReactiveResourceInfo lazyMethod, MediaType mediaType) {
        return Path.class.equals(type);
    }

    public Path readFrom(Class<Path> type, Type genericType, MediaType mediaType, ServerRequestContext context) throws WebApplicationException, IOException {
        Path file = QuarkusServerPathBodyHandler.createFile(context);
        return FileBodyHandler.doRead((MultivaluedMap)context.getRequestHeaders().getRequestHeaders(), (InputStream)context.getInputStream(), (File)file.toFile()).toPath();
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return File.class.equals(type);
    }

    public Path readFrom(Class<Path> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        return FileBodyHandler.doRead(httpHeaders, (InputStream)entityStream, (File)Files.createTempFile("pfx", "sfx", new FileAttribute[0]).toFile()).toPath();
    }

    static Path createFile(ServerRequestContext context) throws IOException {
        RuntimeConfiguration.Body runtimeBodyConfiguration = ResteasyReactiveRecorder.getCurrentDeployment().getRuntimeConfiguration().body();
        boolean deleteUploadedFilesOnEnd = runtimeBodyConfiguration.deleteUploadedFilesOnEnd();
        String uploadsDirectoryStr = runtimeBodyConfiguration.uploadsDirectory();
        Path uploadDirectory = Paths.get(uploadsDirectoryStr, new String[0]);
        try {
            Files.createDirectories(uploadDirectory, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        final Path file = Files.createTempFile(uploadDirectory, "pfx", "sfx", new FileAttribute[0]);
        if (deleteUploadedFilesOnEnd) {
            context.registerCompletionCallback(new CompletionCallback(){

                public void onComplete(Throwable throwable) {
                    ResteasyReactiveRecorder.EXECUTOR_SUPPLIER.get().execute(new Runnable(){

                        @Override
                        public void run() {
                            if (Files.exists(file, new LinkOption[0])) {
                                try {
                                    Files.delete(file);
                                }
                                catch (NoSuchFileException noSuchFileException) {
                                }
                                catch (IOException e) {
                                    log.error((Object)("Cannot remove uploaded file " + file), (Throwable)e);
                                }
                            }
                        }
                    });
                }
            });
        }
        return file;
    }
}

