/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.jackson.runtime.serialisers;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import io.quarkus.resteasy.reactive.jackson.runtime.mappers.JacksonMapperUtil;
import jakarta.inject.Inject;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.jboss.resteasy.reactive.server.jackson.JacksonMessageBodyWriterUtil;
import org.jboss.resteasy.reactive.server.spi.ServerMessageBodyWriter;
import org.jboss.resteasy.reactive.server.spi.ServerRequestContext;

public class BasicServerJacksonMessageBodyWriter
extends ServerMessageBodyWriter.AllWriteableMessageBodyWriter {
    private final ObjectWriter defaultWriter;
    private final Map<JavaType, ObjectWriter> genericWriters = new ConcurrentHashMap<JavaType, ObjectWriter>();

    @Inject
    public BasicServerJacksonMessageBodyWriter(ObjectMapper mapper) {
        this.defaultWriter = JacksonMessageBodyWriterUtil.createDefaultWriter((ObjectMapper)mapper);
    }

    private ObjectWriter getWriter(Type genericType, Object value) {
        JavaType rootType;
        if (value != null && genericType != null && (rootType = JacksonMapperUtil.getGenericRootType(genericType, this.defaultWriter)) != null && rootType.isTypeOrSuperTypeOf(value.getClass())) {
            ObjectWriter writer = this.genericWriters.get(rootType);
            if (writer == null) {
                writer = this.genericWriters.computeIfAbsent(rootType, new Function<JavaType, ObjectWriter>(){

                    @Override
                    public ObjectWriter apply(JavaType type) {
                        return BasicServerJacksonMessageBodyWriter.this.defaultWriter.forType(type);
                    }
                });
            }
            return writer;
        }
        return this.defaultWriter;
    }

    public void writeResponse(Object o, Type genericType, ServerRequestContext context) throws WebApplicationException, IOException {
        OutputStream stream = context.getOrCreateOutputStream();
        if (o instanceof String) {
            stream.write(((String)o).getBytes(StandardCharsets.UTF_8));
        } else {
            this.getWriter(genericType, o).writeValue(stream, o);
        }
        stream.close();
    }

    public void writeTo(Object o, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        JacksonMessageBodyWriterUtil.doLegacyWrite((Object)o, (Annotation[])annotations, httpHeaders, (OutputStream)entityStream, (ObjectWriter)this.getWriter(genericType, o));
    }
}

