/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.rest.client.reactive.runtime;

import io.quarkus.rest.client.reactive.QuarkusRestClientBuilder;
import io.quarkus.rest.client.reactive.runtime.ProxyAddressUtil;
import io.quarkus.restclient.config.RestClientConfig;
import io.quarkus.restclient.config.RestClientsConfig;
import io.quarkus.runtime.configuration.MemorySize;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.net.ssl.HostnameVerifier;
import org.eclipse.microprofile.rest.client.ext.QueryParamStyle;
import org.jboss.resteasy.reactive.client.impl.multipart.PausableHttpPostRequestEncoder;

public class RestClientCDIDelegateBuilder<T> {
    private static final String REST_URL_FORMAT = "quarkus.rest-client.%s.url";
    private static final String REST_URI_FORMAT = "quarkus.rest-client.%s.uri";
    private static final String NONE = "none";
    private final Class<T> jaxrsInterface;
    private final String baseUriFromAnnotation;
    private final String configKey;
    private final RestClientsConfig configRoot;

    public static <T> T createDelegate(Class<T> jaxrsInterface, String baseUriFromAnnotation, String configKey) {
        return new RestClientCDIDelegateBuilder<T>(jaxrsInterface, baseUriFromAnnotation, configKey).build();
    }

    private RestClientCDIDelegateBuilder(Class<T> jaxrsInterface, String baseUriFromAnnotation, String configKey) {
        this(jaxrsInterface, baseUriFromAnnotation, configKey, RestClientsConfig.getInstance());
    }

    RestClientCDIDelegateBuilder(Class<T> jaxrsInterface, String baseUriFromAnnotation, String configKey, RestClientsConfig configRoot) {
        this.jaxrsInterface = jaxrsInterface;
        this.baseUriFromAnnotation = baseUriFromAnnotation;
        this.configKey = configKey;
        this.configRoot = configRoot;
    }

    private T build() {
        QuarkusRestClientBuilder builder = QuarkusRestClientBuilder.newBuilder();
        this.configureBuilder(builder);
        return builder.build(this.jaxrsInterface);
    }

    void configureBuilder(QuarkusRestClientBuilder builder) {
        this.configureBaseUrl(builder);
        this.configureTimeouts(builder);
        this.configureProviders(builder);
        this.configureSsl(builder);
        this.configureRedirects(builder);
        this.configureQueryParamStyle(builder);
        this.configureProxy(builder);
        this.configureShared(builder);
        this.configureCustomProperties(builder);
    }

    private void configureCustomProperties(QuarkusRestClientBuilder builder) {
        Map headers;
        Optional<T> keepAliveEnabled;
        Optional<T> connectionTTL;
        Optional<T> poolSize;
        Optional encoder = this.configRoot.multipartPostEncoderMode;
        if (encoder != null && encoder.isPresent()) {
            PausableHttpPostRequestEncoder.EncoderMode mode = PausableHttpPostRequestEncoder.EncoderMode.valueOf((String)((String)encoder.get()).toUpperCase(Locale.ROOT));
            builder.property("io.quarkus.rest.client.multipart-post-encoder-mode", mode);
        }
        if ((poolSize = RestClientCDIDelegateBuilder.oneOf(this.clientConfigByClassName().connectionPoolSize, this.clientConfigByConfigKey().connectionPoolSize, this.configRoot.connectionPoolSize)).isPresent()) {
            builder.property("io.quarkus.rest.client.connection-pool-size", poolSize.get());
        }
        if ((connectionTTL = RestClientCDIDelegateBuilder.oneOf(this.clientConfigByClassName().connectionTTL, this.clientConfigByConfigKey().connectionTTL, this.configRoot.connectionTTL)).isPresent()) {
            int connectionTTLSeconds = (Integer)connectionTTL.get() / 1000;
            builder.property("io.quarkus.rest.client.connection-ttl", connectionTTLSeconds);
        }
        if ((keepAliveEnabled = RestClientCDIDelegateBuilder.oneOf(this.clientConfigByClassName().keepAliveEnabled, this.clientConfigByConfigKey().keepAliveEnabled, this.configRoot.keepAliveEnabled)).isPresent()) {
            builder.property("io.quarkus.rest.client.keep-alive-enabled", keepAliveEnabled.get());
        }
        if ((headers = this.clientConfigByClassName().headers) == null || headers.isEmpty()) {
            headers = this.clientConfigByConfigKey().headers;
        }
        if (headers == null || headers.isEmpty()) {
            headers = this.configRoot.headers;
        }
        if (headers != null && !headers.isEmpty()) {
            builder.property("io.quarkus.rest.client.static-headers", headers);
        }
        builder.property("io.quarkus.rest.client.disable-contextual-error-messages", this.configRoot.disableContextualErrorMessages);
        Optional<T> userAgent = RestClientCDIDelegateBuilder.oneOf(this.clientConfigByClassName().userAgent, this.clientConfigByConfigKey().userAgent, this.configRoot.userAgent);
        if (userAgent.isPresent()) {
            builder.userAgent((String)userAgent.get());
        }
        Optional<Integer> maxChunkSize = RestClientCDIDelegateBuilder.oneOf(this.clientConfigByClassName().maxChunkSize.map(RestClientCDIDelegateBuilder.intChunkSize()), this.clientConfigByClassName().multipart.maxChunkSize, this.clientConfigByConfigKey().maxChunkSize.map(RestClientCDIDelegateBuilder.intChunkSize()), this.clientConfigByConfigKey().multipart.maxChunkSize, this.configRoot.maxChunkSize.map(RestClientCDIDelegateBuilder.intChunkSize()), this.configRoot.multipart.maxChunkSize);
        builder.property("io.quarkus.rest.client.max-chunk-size", maxChunkSize.orElse(8096));
        Boolean http2 = RestClientCDIDelegateBuilder.oneOf(this.clientConfigByClassName().http2, this.clientConfigByConfigKey().http2).orElse(this.configRoot.http2);
        builder.property("io.quarkus.rest.client.http2", http2);
        Optional<T> alpn = RestClientCDIDelegateBuilder.oneOf(this.clientConfigByClassName().alpn, this.clientConfigByConfigKey().alpn, this.configRoot.alpn);
        if (alpn.isPresent()) {
            builder.property("io.quarkus.rest.client.alpn", alpn.get());
        }
        Boolean captureStacktrace = RestClientCDIDelegateBuilder.oneOf(this.clientConfigByClassName().captureStacktrace, this.clientConfigByConfigKey().captureStacktrace).orElse(this.configRoot.captureStacktrace);
        builder.property("io.quarkus.rest.client.capture-stacktrace", captureStacktrace);
    }

    private static Function<MemorySize, Integer> intChunkSize() {
        return m -> (int)m.asLongValue();
    }

    private void configureProxy(QuarkusRestClientBuilder builder) {
        Optional<T> maybeProxy = RestClientCDIDelegateBuilder.oneOf(this.clientConfigByClassName().proxyAddress, this.clientConfigByConfigKey().proxyAddress, this.configRoot.proxyAddress);
        if (maybeProxy.isEmpty()) {
            return;
        }
        String proxyAddress = (String)maybeProxy.get();
        if (proxyAddress.equals(NONE)) {
            builder.proxyAddress(NONE, 0);
        } else {
            ProxyAddressUtil.HostAndPort hostAndPort = ProxyAddressUtil.parseAddress(proxyAddress);
            builder.proxyAddress(hostAndPort.host, hostAndPort.port);
            RestClientCDIDelegateBuilder.oneOf(this.clientConfigByClassName().proxyUser, this.clientConfigByConfigKey().proxyUser, this.configRoot.proxyUser).ifPresent(builder::proxyUser);
            RestClientCDIDelegateBuilder.oneOf(this.clientConfigByClassName().proxyPassword, this.clientConfigByConfigKey().proxyPassword, this.configRoot.proxyPassword).ifPresent(builder::proxyPassword);
            RestClientCDIDelegateBuilder.oneOf(this.clientConfigByClassName().nonProxyHosts, this.clientConfigByConfigKey().nonProxyHosts, this.configRoot.nonProxyHosts).ifPresent(builder::nonProxyHosts);
        }
    }

    private void configureQueryParamStyle(QuarkusRestClientBuilder builder) {
        Optional<T> maybeQueryParamStyle = RestClientCDIDelegateBuilder.oneOf(this.clientConfigByClassName().queryParamStyle, this.clientConfigByConfigKey().queryParamStyle, this.configRoot.queryParamStyle);
        if (maybeQueryParamStyle.isPresent()) {
            QueryParamStyle queryParamStyle = (QueryParamStyle)maybeQueryParamStyle.get();
            builder.queryParamStyle(queryParamStyle);
        }
    }

    private void configureRedirects(QuarkusRestClientBuilder builder) {
        Optional<T> maybeFollowRedirects;
        Optional<T> maxRedirects = RestClientCDIDelegateBuilder.oneOf(this.clientConfigByClassName().maxRedirects, this.clientConfigByConfigKey().maxRedirects, this.configRoot.maxRedirects);
        if (maxRedirects.isPresent()) {
            builder.property("io.quarkus.rest.client.max-redirects", maxRedirects.get());
        }
        if ((maybeFollowRedirects = RestClientCDIDelegateBuilder.oneOf(this.clientConfigByClassName().followRedirects, this.clientConfigByConfigKey().followRedirects, this.configRoot.followRedirects)).isPresent()) {
            builder.followRedirects((Boolean)maybeFollowRedirects.get());
        }
    }

    private void configureShared(QuarkusRestClientBuilder builder) {
        Optional<T> shared = RestClientCDIDelegateBuilder.oneOf(this.clientConfigByClassName().shared, this.clientConfigByConfigKey().shared);
        if (shared.isPresent()) {
            Optional<T> name;
            builder.property("io.quarkus.rest.client.shared", shared.get());
            if (((Boolean)shared.get()).booleanValue() && (name = RestClientCDIDelegateBuilder.oneOf(this.clientConfigByClassName().name, this.clientConfigByConfigKey().name)).isPresent()) {
                builder.property("io.quarkus.rest.client.name", name.get());
            }
        }
    }

    private void configureSsl(QuarkusRestClientBuilder builder) {
        Optional<T> maybeHostnameVerifier;
        Optional<T> maybeKeyStore;
        Optional<T> maybeTrustStore = RestClientCDIDelegateBuilder.oneOf(this.clientConfigByClassName().trustStore, this.clientConfigByConfigKey().trustStore, this.configRoot.trustStore);
        if (maybeTrustStore.isPresent() && !((String)maybeTrustStore.get()).isBlank() && !NONE.equals(maybeTrustStore.get())) {
            this.registerTrustStore((String)maybeTrustStore.get(), builder);
        }
        if ((maybeKeyStore = RestClientCDIDelegateBuilder.oneOf(this.clientConfigByClassName().keyStore, this.clientConfigByConfigKey().keyStore, this.configRoot.keyStore)).isPresent() && !((String)maybeKeyStore.get()).isBlank() && !NONE.equals(maybeKeyStore.get())) {
            this.registerKeyStore((String)maybeKeyStore.get(), builder);
        }
        if ((maybeHostnameVerifier = RestClientCDIDelegateBuilder.oneOf(this.clientConfigByClassName().hostnameVerifier, this.clientConfigByConfigKey().hostnameVerifier, this.configRoot.hostnameVerifier)).isPresent()) {
            this.registerHostnameVerifier((String)maybeHostnameVerifier.get(), builder);
        }
        RestClientCDIDelegateBuilder.oneOf(this.clientConfigByClassName().verifyHost, this.clientConfigByConfigKey().verifyHost, this.configRoot.verifyHost).ifPresent(builder::verifyHost);
    }

    private void registerHostnameVerifier(String verifier, QuarkusRestClientBuilder builder) {
        try {
            Class<?> verifierClass = Thread.currentThread().getContextClassLoader().loadClass(verifier);
            builder.hostnameVerifier((HostnameVerifier)verifierClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Could not find a public, no-argument constructor for the hostname verifier class " + verifier, e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Could not find hostname verifier class " + verifier, e);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException("Failed to instantiate hostname verifier class " + verifier + ". Make sure it has a public, no-argument constructor", e);
        }
        catch (ClassCastException e) {
            throw new RuntimeException("The provided hostname verifier " + verifier + " is not an instance of HostnameVerifier", e);
        }
    }

    private void registerKeyStore(String keyStorePath, QuarkusRestClientBuilder builder) {
        Optional<T> keyStorePassword = RestClientCDIDelegateBuilder.oneOf(this.clientConfigByClassName().keyStorePassword, this.clientConfigByConfigKey().keyStorePassword, this.configRoot.keyStorePassword);
        Optional<String> keyStoreType = RestClientCDIDelegateBuilder.oneOf(this.clientConfigByClassName().keyStoreType, this.clientConfigByConfigKey().keyStoreType, this.configRoot.keyStoreType);
        try {
            KeyStore keyStore = KeyStore.getInstance(keyStoreType.orElse("JKS"));
            if (keyStorePassword.isEmpty()) {
                throw new IllegalArgumentException("No password provided for keystore");
            }
            String password = (String)keyStorePassword.get();
            try (InputStream input = this.locateStream(keyStorePath);){
                keyStore.load(input, password.toCharArray());
            }
            catch (IOException | NoSuchAlgorithmException | CertificateException e) {
                throw new IllegalArgumentException("Failed to initialize trust store from classpath resource " + keyStorePath, e);
            }
            builder.keyStore(keyStore, password);
        }
        catch (KeyStoreException e) {
            throw new IllegalArgumentException("Failed to initialize trust store from " + keyStorePath, e);
        }
    }

    private void registerTrustStore(String trustStorePath, QuarkusRestClientBuilder builder) {
        Optional<T> maybeTrustStorePassword = RestClientCDIDelegateBuilder.oneOf(this.clientConfigByClassName().trustStorePassword, this.clientConfigByConfigKey().trustStorePassword, this.configRoot.trustStorePassword);
        Optional<String> maybeTrustStoreType = RestClientCDIDelegateBuilder.oneOf(this.clientConfigByClassName().trustStoreType, this.clientConfigByConfigKey().trustStoreType, this.configRoot.trustStoreType);
        try {
            KeyStore trustStore = KeyStore.getInstance(maybeTrustStoreType.orElse("JKS"));
            if (maybeTrustStorePassword.isEmpty()) {
                throw new IllegalArgumentException("No password provided for truststore");
            }
            String password = (String)maybeTrustStorePassword.get();
            try (InputStream input = this.locateStream(trustStorePath);){
                trustStore.load(input, password.toCharArray());
            }
            catch (IOException | NoSuchAlgorithmException | CertificateException e) {
                throw new IllegalArgumentException("Failed to initialize trust store from classpath resource " + trustStorePath, e);
            }
            builder.trustStore(trustStore, password);
        }
        catch (KeyStoreException e) {
            throw new IllegalArgumentException("Failed to initialize trust store from " + trustStorePath, e);
        }
    }

    private InputStream locateStream(String path) throws FileNotFoundException {
        File certificateFile;
        if (path.startsWith("classpath:")) {
            path = path.replaceFirst("classpath:", "");
            InputStream resultStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
            if (resultStream == null) {
                resultStream = this.getClass().getResourceAsStream(path);
            }
            if (resultStream == null) {
                throw new IllegalArgumentException("Classpath resource " + path + " not found for MicroProfile Rest Client SSL configuration");
            }
            return resultStream;
        }
        if (path.startsWith("file:")) {
            path = path.replaceFirst("file:", "");
        }
        if (!(certificateFile = new File(path)).isFile()) {
            throw new IllegalArgumentException("Certificate file: " + path + " not found for MicroProfile Rest Client SSL configuration");
        }
        return new FileInputStream(certificateFile);
    }

    private void configureProviders(QuarkusRestClientBuilder builder) {
        Optional<T> maybeProviders = RestClientCDIDelegateBuilder.oneOf(this.clientConfigByClassName().providers, this.clientConfigByConfigKey().providers, this.configRoot.providers);
        if (maybeProviders.isPresent()) {
            this.registerProviders(builder, (String)maybeProviders.get());
        }
    }

    private void registerProviders(QuarkusRestClientBuilder builder, String providersAsString) {
        for (String s : providersAsString.split(",")) {
            builder.register(this.providerClassForName(s.trim()));
        }
    }

    private Class<?> providerClassForName(String name) {
        try {
            return Class.forName(name, true, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Could not find provider class: " + name);
        }
    }

    private void configureTimeouts(QuarkusRestClientBuilder builder) {
        Long readTimeout;
        Long connectTimeout = RestClientCDIDelegateBuilder.oneOf(this.clientConfigByClassName().connectTimeout, this.clientConfigByConfigKey().connectTimeout).orElse(this.configRoot.connectTimeout);
        if (connectTimeout != null) {
            builder.connectTimeout(connectTimeout, TimeUnit.MILLISECONDS);
        }
        if ((readTimeout = RestClientCDIDelegateBuilder.oneOf(this.clientConfigByClassName().readTimeout, this.clientConfigByConfigKey().readTimeout).orElse(this.configRoot.readTimeout)) != null) {
            builder.readTimeout(readTimeout, TimeUnit.MILLISECONDS);
        }
    }

    private void configureBaseUrl(QuarkusRestClientBuilder builder) {
        Optional<String> propertyOptional = RestClientCDIDelegateBuilder.oneOf(this.clientConfigByClassName().uri, this.clientConfigByConfigKey().uri);
        if (propertyOptional.isEmpty()) {
            propertyOptional = RestClientCDIDelegateBuilder.oneOf(this.clientConfigByClassName().url, this.clientConfigByConfigKey().url);
        }
        if ((this.baseUriFromAnnotation == null || this.baseUriFromAnnotation.isEmpty()) && propertyOptional.isEmpty()) {
            String propertyPrefix = this.configKey != null ? this.configKey : "\"" + this.jaxrsInterface.getName() + "\"";
            throw new IllegalArgumentException(String.format("Unable to determine the proper baseUrl/baseUri. Consider registering using @RegisterRestClient(baseUri=\"someuri\"), @RegisterRestClient(configKey=\"orkey\"), or by adding '%s' or '%s' to your Quarkus configuration", String.format(REST_URL_FORMAT, propertyPrefix), String.format(REST_URI_FORMAT, propertyPrefix)));
        }
        String baseUrl = propertyOptional.orElse(this.baseUriFromAnnotation);
        try {
            builder.baseUri(new URI(baseUrl));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("The value of URL was invalid " + baseUrl, e);
        }
    }

    private RestClientConfig clientConfigByConfigKey() {
        return this.configRoot.getClientConfig(this.configKey);
    }

    private RestClientConfig clientConfigByClassName() {
        return this.configRoot.getClientConfig(this.jaxrsInterface);
    }

    @SafeVarargs
    private static <T> Optional<T> oneOf(Optional<T> ... optionals) {
        for (Optional<T> o : optionals) {
            if (o == null || !o.isPresent()) continue;
            return o;
        }
        return Optional.empty();
    }
}

