/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.rest.client.reactive.runtime;

import io.quarkus.proxy.ProxyType;
import io.quarkus.rest.client.reactive.QuarkusRestClientBuilder;
import io.quarkus.rest.client.reactive.runtime.BeanGrabber;
import io.quarkus.rest.client.reactive.runtime.RestClientBuilderImpl;
import io.quarkus.rest.client.reactive.runtime.context.ClientHeadersFactoryContextResolver;
import io.quarkus.tls.TlsConfiguration;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpClientRequest;
import jakarta.ws.rs.core.Configuration;
import java.net.URI;
import java.net.URL;
import java.security.KeyStore;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.eclipse.microprofile.rest.client.RestClientDefinitionException;
import org.eclipse.microprofile.rest.client.ext.ClientHeadersFactory;
import org.eclipse.microprofile.rest.client.ext.QueryParamStyle;
import org.jboss.resteasy.reactive.client.api.ClientLogger;
import org.jboss.resteasy.reactive.client.api.LoggingScope;

public class QuarkusRestClientBuilderImpl
implements QuarkusRestClientBuilder {
    private final RestClientBuilderImpl delegate;

    public QuarkusRestClientBuilderImpl(RestClientBuilderImpl delegate) {
        this.delegate = delegate;
    }

    @Override
    public QuarkusRestClientBuilder baseUrl(URL url) {
        this.delegate.baseUrl(url);
        return this;
    }

    @Override
    public QuarkusRestClientBuilder baseUri(URI uri) {
        this.delegate.baseUri(uri);
        return this;
    }

    @Override
    public QuarkusRestClientBuilder connectTimeout(long timeout, TimeUnit unit) {
        this.delegate.connectTimeout(timeout, unit);
        return this;
    }

    @Override
    public QuarkusRestClientBuilder readTimeout(long timeout, TimeUnit unit) {
        this.delegate.readTimeout(timeout, unit);
        return this;
    }

    @Override
    public QuarkusRestClientBuilder tlsConfiguration(TlsConfiguration tlsConfiguration) {
        this.delegate.tlsConfiguration(tlsConfiguration);
        return this;
    }

    @Override
    public QuarkusRestClientBuilder sslContext(SSLContext sslContext) {
        this.delegate.sslContext(sslContext);
        return this;
    }

    @Override
    public QuarkusRestClientBuilder verifyHost(boolean verifyHost) {
        this.delegate.verifyHost(verifyHost);
        return this;
    }

    @Override
    public QuarkusRestClientBuilder trustStore(KeyStore trustStore) {
        this.delegate.trustStore(trustStore);
        return this;
    }

    @Override
    public QuarkusRestClientBuilder trustStore(KeyStore trustStore, String trustStorePassword) {
        this.delegate.trustStore(trustStore, trustStorePassword);
        return this;
    }

    @Override
    public QuarkusRestClientBuilder keyStore(KeyStore keyStore, String keystorePassword) {
        this.delegate.keyStore(keyStore, keystorePassword);
        return this;
    }

    @Override
    public QuarkusRestClientBuilder hostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.delegate.hostnameVerifier(hostnameVerifier);
        return this;
    }

    @Override
    public QuarkusRestClientBuilder followRedirects(boolean follow) {
        this.delegate.followRedirects(follow);
        return this;
    }

    @Override
    public QuarkusRestClientBuilder proxyAddress(String proxyHost, int proxyPort) {
        this.delegate.proxyAddress(proxyHost, proxyPort);
        return this;
    }

    @Override
    public QuarkusRestClientBuilder proxyPassword(String proxyPassword) {
        this.delegate.proxyPassword(proxyPassword);
        return this;
    }

    @Override
    public QuarkusRestClientBuilder proxyUser(String proxyUser) {
        this.delegate.proxyUser(proxyUser);
        return this;
    }

    @Override
    public QuarkusRestClientBuilder nonProxyHosts(String nonProxyHosts) {
        this.delegate.nonProxyHosts(nonProxyHosts);
        return this;
    }

    @Override
    public QuarkusRestClientBuilder proxyConnectTimeout(Duration connectTimeout) {
        this.delegate.proxyConnectTimeout(connectTimeout);
        return this;
    }

    @Override
    public QuarkusRestClientBuilder proxyType(ProxyType proxyType) {
        this.delegate.proxyType(proxyType);
        return this;
    }

    @Override
    public QuarkusRestClientBuilder multipartPostEncoderMode(String mode) {
        this.delegate.multipartPostEncoderMode(mode);
        return this;
    }

    @Override
    public QuarkusRestClientBuilder queryParamStyle(QueryParamStyle style) {
        this.delegate.queryParamStyle(style);
        return this;
    }

    public Configuration getConfiguration() {
        return this.delegate.getConfiguration();
    }

    public QuarkusRestClientBuilder property(String name, Object value) {
        this.delegate.property(name, value);
        return this;
    }

    public QuarkusRestClientBuilder register(Class<?> componentClass) {
        this.delegate.register(componentClass);
        return this;
    }

    public QuarkusRestClientBuilder register(Class<?> componentClass, int priority) {
        this.delegate.register(componentClass, priority);
        return this;
    }

    public QuarkusRestClientBuilder register(Class<?> componentClass, Class<?> ... contracts) {
        this.delegate.register(componentClass, contracts);
        return null;
    }

    public QuarkusRestClientBuilder register(Class<?> componentClass, Map<Class<?>, Integer> contracts) {
        this.delegate.register(componentClass, contracts);
        return this;
    }

    public QuarkusRestClientBuilder register(Object component) {
        this.delegate.register(component);
        return this;
    }

    public QuarkusRestClientBuilder register(Object component, int priority) {
        this.delegate.register(component, priority);
        return this;
    }

    public QuarkusRestClientBuilder register(Object component, Class<?> ... contracts) {
        this.delegate.register(component, contracts);
        return this;
    }

    public QuarkusRestClientBuilder register(Object component, Map<Class<?>, Integer> contracts) {
        this.delegate.register(component, contracts);
        return this;
    }

    @Override
    public QuarkusRestClientBuilder clientHeadersFactory(Class<? extends ClientHeadersFactory> clientHeadersFactoryClass) {
        ClientHeadersFactory bean = BeanGrabber.getBeanIfDefined(clientHeadersFactoryClass);
        if (bean == null) {
            throw new IllegalArgumentException("Failed to instantiate the client headers factory " + String.valueOf(clientHeadersFactoryClass) + ". Make sure the bean is properly configured for CDI injection.");
        }
        return this.clientHeadersFactory(bean);
    }

    @Override
    public QuarkusRestClientBuilder clientHeadersFactory(ClientHeadersFactory clientHeadersFactory) {
        this.delegate.register(new ClientHeadersFactoryContextResolver(clientHeadersFactory));
        return this;
    }

    public QuarkusRestClientBuilder httpClientOptions(Class<? extends HttpClientOptions> httpClientOptionsClass) {
        this.delegate.httpClientOptions((Class)httpClientOptionsClass);
        return this;
    }

    public QuarkusRestClientBuilder httpClientOptions(HttpClientOptions httpClientOptions) {
        this.delegate.httpClientOptions(httpClientOptions);
        return this;
    }

    public QuarkusRestClientBuilder httpClientOptionsCustomizer(Consumer<HttpClientOptions> httpClientOptionsCustomizer) {
        this.delegate.clientOptionsCustomizer(httpClientOptionsCustomizer);
        return this;
    }

    public QuarkusRestClientBuilder httpClientRequestCustomizer(Consumer<HttpClientRequest> httpClientOptionsCustomizer) {
        this.delegate.clientRequestCustomizer(httpClientOptionsCustomizer);
        return this;
    }

    @Override
    public QuarkusRestClientBuilder clientLogger(ClientLogger clientLogger) {
        this.delegate.clientLogger(clientLogger);
        return this;
    }

    @Override
    public QuarkusRestClientBuilder loggingScope(LoggingScope loggingScope) {
        this.delegate.loggingScope(loggingScope);
        return this;
    }

    @Override
    public QuarkusRestClientBuilder loggingBodyLimit(Integer limit) {
        this.delegate.loggingBodyLimit(limit);
        return this;
    }

    @Override
    public QuarkusRestClientBuilder trustAll(boolean trustAll) {
        this.delegate.trustAll(trustAll);
        return this;
    }

    @Override
    public QuarkusRestClientBuilder userAgent(String userAgent) {
        this.delegate.userAgent(userAgent);
        return this;
    }

    @Override
    public QuarkusRestClientBuilder disableDefaultMapper(Boolean disable) {
        this.delegate.disableDefaultMapper(disable);
        return this;
    }

    @Override
    public QuarkusRestClientBuilder enableCompression(boolean enableCompression) {
        this.delegate.enableCompression(enableCompression);
        return this;
    }

    @Override
    public <T> T build(Class<T> clazz) throws IllegalStateException, RestClientDefinitionException {
        return this.delegate.build(clazz);
    }
}

