/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.rest.client.reactive.deployment;

import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.rest.client.reactive.deployment.DotNames;
import io.quarkus.runtime.util.HashUtil;
import javax.ws.rs.core.Response;
import org.eclipse.microprofile.rest.client.ext.ResponseExceptionMapper;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

class ClientExceptionMapperHandler {
    private final ClassOutput classOutput;

    ClientExceptionMapperHandler(ClassOutput classOutput) {
        this.classOutput = classOutput;
    }

    Result generateResponseExceptionMapper(AnnotationInstance instance) {
        if (!DotNames.CLIENT_EXCEPTION_MAPPER.equals((Object)instance.name())) {
            throw new IllegalArgumentException("'clientExceptionMapperInstance' must be an instance of " + DotNames.CLIENT_EXCEPTION_MAPPER);
        }
        MethodInfo targetMethod = null;
        boolean isValid = false;
        if (instance.target().kind() == AnnotationTarget.Kind.METHOD) {
            targetMethod = instance.target().asMethod();
            if (ClientExceptionMapperHandler.ignoreAnnotation(targetMethod)) {
                return null;
            }
            if ((targetMethod.flags() & 8) != 0) {
                String returnTypeClassName = targetMethod.returnType().name().toString();
                try {
                    boolean returnsRuntimeException = RuntimeException.class.isAssignableFrom(Class.forName(returnTypeClassName, false, Thread.currentThread().getContextClassLoader()));
                    if (returnsRuntimeException) {
                        isValid = true;
                    }
                }
                catch (ClassNotFoundException returnsRuntimeException) {
                    // empty catch block
                }
            }
        }
        if (!isValid) {
            String message = DotNames.CLIENT_EXCEPTION_MAPPER + " is only supported on static methods of REST Client interfaces that take 'javax.ws.rs.core.Response' as a single parameter and return 'java.lang.RuntimeException'.";
            if (targetMethod != null) {
                message = message + " Offending instance is '" + targetMethod.declaringClass().name().toString() + "#" + targetMethod.name() + "'";
            }
            throw new IllegalStateException(message);
        }
        StringBuilder sigBuilder = new StringBuilder();
        sigBuilder.append(targetMethod.name()).append("_").append(targetMethod.returnType().name().toString());
        for (Type i : targetMethod.parameterTypes()) {
            sigBuilder.append(i.name().toString());
        }
        int priority = 5000;
        AnnotationValue priorityAnnotationValue = instance.value("priority");
        if (priorityAnnotationValue != null) {
            priority = priorityAnnotationValue.asInt();
        }
        ClassInfo restClientInterfaceClassInfo = targetMethod.declaringClass();
        String generatedClassName = restClientInterfaceClassInfo.name().toString() + "_" + targetMethod.name() + "_ResponseExceptionMapper_" + HashUtil.sha1((String)sigBuilder.toString());
        try (ClassCreator cc = ClassCreator.builder().classOutput(this.classOutput).className(generatedClassName).interfaces(new Class[]{ResponseExceptionMapper.class}).build();){
            MethodCreator toThrowable = cc.getMethodCreator("toThrowable", Throwable.class, new Class[]{Response.class});
            ResultHandle resultHandle = toThrowable.invokeStaticInterfaceMethod(MethodDescriptor.ofMethod((String)restClientInterfaceClassInfo.name().toString(), (String)targetMethod.name(), (String)targetMethod.returnType().name().toString(), (String[])new String[]{targetMethod.parameterType(0).name().toString()}), new ResultHandle[]{toThrowable.getMethodParam(0)});
            toThrowable.returnValue(resultHandle);
            if (priority != 5000) {
                MethodCreator getPriority = cc.getMethodCreator("getPriority", Integer.TYPE, new Class[0]);
                getPriority.returnValue(getPriority.load(priority));
            }
        }
        return new Result(restClientInterfaceClassInfo.name().toString(), generatedClassName, priority);
    }

    private static boolean ignoreAnnotation(MethodInfo methodInfo) {
        return methodInfo.declaringClass().name().toString().contains("$Companion");
    }

    static class Result {
        final String interfaceName;
        final String generatedClassName;
        final int priority;

        Result(String interfaceName, String generatedClassName, int priority) {
            this.interfaceName = interfaceName;
            this.generatedClassName = generatedClassName;
            this.priority = priority;
        }
    }
}

