/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.restclient.config.deployment;

import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.builder.item.SimpleBuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.restclient.config.AbstractRestClientConfigBuilder;
import io.quarkus.restclient.config.RegisteredRestClient;
import io.quarkus.restclient.config.RestClientKeysProvider;
import io.quarkus.restclient.config.RestClientsBuildTimeConfig;
import io.quarkus.runtime.configuration.ConfigurationException;
import io.smallrye.config.ConfigValue;
import io.smallrye.config.SmallRyeConfig;
import io.smallrye.config.SmallRyeConfigBuilder;
import io.smallrye.config.SmallRyeConfigBuilderCustomizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;

public final class RestClientsBuildTimeConfigBuildItem
extends SimpleBuildItem {
    private final List<RegisteredRestClient> restClients;
    private final SmallRyeConfig config;
    private final RestClientsBuildTimeConfig restClientsBuildTimeConfig;

    public RestClientsBuildTimeConfigBuildItem(final List<RegisteredRestClient> restClients) {
        this.restClients = Collections.unmodifiableList(restClients);
        this.config = new SmallRyeConfigBuilder().withSources(new ConfigSource[]{new ConfigSource(){
            final SmallRyeConfig config = (SmallRyeConfig)ConfigProvider.getConfig().unwrap(SmallRyeConfig.class);

            public Set<String> getPropertyNames() {
                HashSet<String> properties = new HashSet<String>();
                this.config.getPropertyNames().forEach(properties::add);
                return properties;
            }

            public String getValue(String propertyName) {
                ConfigValue configValue = this.config.getConfigValue(propertyName);
                if (configValue.getValue() != null && !configValue.isDefault()) {
                    return configValue.getValue();
                }
                return null;
            }

            public String getName() {
                return "SmallRye Config";
            }
        }}).withCustomizers(new SmallRyeConfigBuilderCustomizer[]{new SmallRyeConfigBuilderCustomizer(){

            public void configBuilder(SmallRyeConfigBuilder builder) {
                new AbstractRestClientConfigBuilder(){

                    public List<RegisteredRestClient> getRestClients() {
                        return restClients;
                    }
                }.configBuilder(builder);
            }
        }}).withMapping(RestClientsBuildTimeConfig.class).withMappingIgnore("quarkus.**").build();
        this.restClientsBuildTimeConfig = (RestClientsBuildTimeConfig)this.config.getConfigMapping(RestClientsBuildTimeConfig.class);
        RestClientKeysProvider.KEYS.clear();
    }

    public List<RegisteredRestClient> getRestClients() {
        return this.restClients;
    }

    public SmallRyeConfig getConfig() {
        return this.config;
    }

    public RestClientsBuildTimeConfig getRestClientsBuildTimeConfig() {
        return this.restClientsBuildTimeConfig;
    }

    public Optional<BuiltinScope> getScope(Capabilities capabilities, ClassInfo restClientInterface) {
        ArrayList<Optional<BuiltinScope>> discoveredScopes = new ArrayList<Optional<BuiltinScope>>();
        ((RestClientsBuildTimeConfig.RestClientBuildConfig)this.restClientsBuildTimeConfig.clients().get(restClientInterface.name().toString())).scope().ifPresent(s -> discoveredScopes.add(RestClientsBuildTimeConfigBuildItem.builtinScopeFromName(DotName.createSimple((String)s), restClientInterface.name().toString())));
        Set annotations = restClientInterface.annotationsMap().keySet();
        for (DotName annotationName : annotations) {
            BuiltinScope builtinScope = BuiltinScope.from((DotName)annotationName);
            if (builtinScope == null) continue;
            discoveredScopes.add(Optional.of(builtinScope));
        }
        this.restClientsBuildTimeConfig.scope().ifPresent(s -> discoveredScopes.add(RestClientsBuildTimeConfigBuildItem.builtinScopeFromName(DotName.createSimple((String)s), restClientInterface.name().toString())));
        Optional<BuiltinScope> scope = discoveredScopes.stream().filter(Optional::isPresent).map(Optional::get).findFirst();
        if (scope.isPresent()) {
            if (scope.get().equals((Object)BuiltinScope.SESSION)) {
                if (capabilities.isPresent("io.quarkus.servlet")) {
                    return scope;
                }
            } else {
                return scope;
            }
        }
        return Optional.empty();
    }

    private static Optional<BuiltinScope> builtinScopeFromName(DotName scopeName, String restClientClass) {
        BuiltinScope scope = BuiltinScope.from((DotName)scopeName);
        if (scope != null) {
            return Optional.of(scope);
        }
        for (BuiltinScope builtinScope : BuiltinScope.values()) {
            if (!builtinScope.getName().withoutPackagePrefix().equalsIgnoreCase(scopeName.toString())) continue;
            return Optional.of(builtinScope);
        }
        throw new ConfigurationException(String.format("Not possible to define the scope %s for the REST client %s ", scopeName, restClientClass));
    }
}

