/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.runtime.datasource;

import io.quarkus.redis.datasource.SortArgs;
import io.quarkus.redis.runtime.datasource.AbstractRedisCommands;
import io.quarkus.redis.runtime.datasource.Marshaller;
import io.quarkus.redis.runtime.datasource.RedisCommand;
import io.quarkus.redis.runtime.datasource.RedisCommandExecutor;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.vertx.mutiny.redis.client.Command;
import io.vertx.mutiny.redis.client.Response;
import java.lang.reflect.Type;
import java.util.List;

public class ReactiveSortable<K, V>
extends AbstractRedisCommands {
    private final Type typeOfValue;
    private static final SortArgs DEFAULT_INSTANCE = new SortArgs();

    public ReactiveSortable(RedisCommandExecutor redis, Marshaller marshaller, Type typeOfValue) {
        super(redis, marshaller);
        this.typeOfValue = typeOfValue;
    }

    public Uni<List<V>> sort(K key) {
        return this.sort(key, DEFAULT_INSTANCE);
    }

    public Uni<List<V>> sort(K key, SortArgs sortArguments) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull((Object)sortArguments, (String)"sortArguments");
        return this.execute(RedisCommand.of(Command.SORT).put(this.marshaller.encode(key)).putArgs(sortArguments)).map(r -> this.marshaller.decodeAsList((Response)r, this.typeOfValue));
    }

    public Uni<Long> sortAndStore(K key, K destination, SortArgs args) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull(destination, (String)"destination");
        ParameterValidation.nonNull((Object)args, (String)"args");
        RedisCommand cmd = RedisCommand.of(Command.SORT).put(this.marshaller.encode(key)).putAll(args.toArgs()).put("STORE").put(this.marshaller.encode(destination));
        return this.execute(cmd).map(Response::toLong);
    }

    public Uni<Long> sortAndStore(K key, K destination) {
        return this.sortAndStore(key, destination, DEFAULT_INSTANCE);
    }
}

