/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.runtime.datasource;

import io.quarkus.redis.datasource.list.KeyValue;
import io.quarkus.redis.datasource.list.LPosArgs;
import io.quarkus.redis.datasource.list.Position;
import io.quarkus.redis.runtime.datasource.Marshaller;
import io.quarkus.redis.runtime.datasource.ReactiveSortable;
import io.quarkus.redis.runtime.datasource.RedisCommand;
import io.quarkus.redis.runtime.datasource.RedisCommandExecutor;
import io.quarkus.redis.runtime.datasource.Validation;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.vertx.mutiny.redis.client.Command;
import io.vertx.mutiny.redis.client.Response;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class AbstractListCommands<K, V>
extends ReactiveSortable<K, V> {
    protected final Type typeOfValue;
    protected final Type typeOfKey;
    protected static final LPosArgs DEFAULT_INSTANCE = new LPosArgs();

    AbstractListCommands(RedisCommandExecutor redis, Type k, Type v) {
        super(redis, new Marshaller(k, v), v);
        this.typeOfKey = k;
        this.typeOfValue = v;
    }

    Uni<Response> _blmove(K source, K destination, Position positionInSource, Position positionInDest, Duration timeout) {
        ParameterValidation.nonNull(source, (String)"source");
        ParameterValidation.nonNull(destination, (String)"destination");
        ParameterValidation.nonNull((Object)((Object)positionInSource), (String)"positionInSource");
        ParameterValidation.nonNull((Object)((Object)positionInDest), (String)"positionInDest");
        ParameterValidation.validate((Duration)timeout, (String)"timeout");
        return this.execute(RedisCommand.of(Command.BLMOVE).put(this.marshaller.encode(source)).put(this.marshaller.encode(destination)).put(positionInSource.name()).put(positionInDest.name()).put(timeout.toSeconds()));
    }

    V decodeV(Response r) {
        return (V)this.marshaller.decode(this.typeOfValue, r);
    }

    Uni<Response> _blmpop(Duration timeout, Position position, K ... keys) {
        ParameterValidation.nonNull((Object)((Object)position), (String)"position");
        Validation.notNullOrEmpty(keys, "keys");
        ParameterValidation.doesNotContainNull((Object[])keys, (String)"keys");
        ParameterValidation.validate((Duration)timeout, (String)"timeout");
        RedisCommand cmd = RedisCommand.of(Command.BLMPOP);
        cmd.put(timeout.toSeconds());
        cmd.put(keys.length);
        cmd.putAll(this.marshaller.encode(keys));
        cmd.put(position.name());
        return this.execute(cmd);
    }

    KeyValue<K, V> decodeKeyValue(Response r) {
        if (r != null && r.getDelegate() != null) {
            Response r1 = r.get(0);
            Response r2 = r.get(1);
            Object key = this.marshaller.decode(this.typeOfKey, r1);
            Object val = this.marshaller.decode(this.typeOfValue, r2);
            return new KeyValue(key, val);
        }
        return null;
    }

    KeyValue<K, V> decodeKeyValueWithList(Response r) {
        if (r != null && r.getDelegate() != null) {
            Response r1 = r.get(0);
            Response r2 = r.get(1).get(0);
            Object key = this.marshaller.decode(this.typeOfKey, r1);
            Object val = this.marshaller.decode(this.typeOfValue, r2);
            return new KeyValue(key, val);
        }
        return null;
    }

    Uni<Response> _blmpop(Duration timeout, Position position, int count, K ... keys) {
        ParameterValidation.nonNull((Object)((Object)position), (String)"position");
        Validation.notNullOrEmpty(keys, "keys");
        ParameterValidation.doesNotContainNull((Object[])keys, (String)"keys");
        ParameterValidation.validate((Duration)timeout, (String)"timeout");
        ParameterValidation.positive((int)count, (String)"count");
        RedisCommand cmd = RedisCommand.of(Command.BLMPOP);
        cmd.put(timeout.toSeconds());
        cmd.put(keys.length);
        cmd.putAll(this.marshaller.encode(keys));
        cmd.put(position.name());
        cmd.put("COUNT").put(count);
        return this.execute(cmd);
    }

    List<KeyValue<K, V>> decodeListOfKeyValue(Response r) {
        if (r == null || r.getDelegate() == null) {
            return Collections.emptyList();
        }
        ArrayList<KeyValue<K, V>> res = new ArrayList<KeyValue<K, V>>();
        Object key = this.marshaller.decode(this.typeOfKey, r.get(0).toBytes());
        for (Response item : r.get(1)) {
            if (item == null) {
                res.add(KeyValue.of(key, null));
                continue;
            }
            res.add(KeyValue.of(key, this.marshaller.decode(this.typeOfValue, item)));
        }
        return res;
    }

    Uni<Response> _blpop(Duration timeout, K ... keys) {
        Validation.notNullOrEmpty(keys, "keys");
        ParameterValidation.doesNotContainNull((Object[])keys, (String)"keys");
        ParameterValidation.validate((Duration)timeout, (String)"timeout");
        RedisCommand cmd = RedisCommand.of(Command.BLPOP);
        cmd.put(timeout.toSeconds());
        cmd.putAll(this.marshaller.encode(keys));
        cmd.put(timeout.toSeconds());
        return this.execute(cmd);
    }

    Uni<Response> _brpop(Duration timeout, K ... keys) {
        Validation.notNullOrEmpty(keys, "keys");
        ParameterValidation.doesNotContainNull((Object[])keys, (String)"keys");
        ParameterValidation.validate((Duration)timeout, (String)"timeout");
        RedisCommand cmd = RedisCommand.of(Command.BRPOP);
        cmd.put(timeout.toSeconds());
        cmd.putAll(this.marshaller.encode(keys));
        cmd.put(timeout.toSeconds());
        return this.execute(cmd);
    }

    Uni<Response> _brpoplpush(Duration timeout, K source, K destination) {
        ParameterValidation.validate((Duration)timeout, (String)"timeout");
        ParameterValidation.nonNull(source, (String)"source");
        ParameterValidation.nonNull(destination, (String)"destination");
        return this.execute(RedisCommand.of(Command.BRPOPLPUSH).put(this.marshaller.encode(source)).put(this.marshaller.encode(destination)).put(timeout.toSeconds()));
    }

    Uni<Response> _lindex(K key, long index) {
        ParameterValidation.nonNull(key, (String)"key");
        return this.execute(RedisCommand.of(Command.LINDEX).put(this.marshaller.encode(key)).put(index));
    }

    Uni<Response> _linsertBeforePivot(K key, V pivot, V element) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull(pivot, (String)"pivot");
        ParameterValidation.nonNull(element, (String)"element");
        return this.execute(RedisCommand.of(Command.LINSERT).put(this.marshaller.encode(key)).put("BEFORE").put(this.marshaller.encode(pivot)).put(this.marshaller.encode(element)));
    }

    Uni<Response> _linsertAfterPivot(K key, V pivot, V element) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull(pivot, (String)"pivot");
        ParameterValidation.nonNull(element, (String)"element");
        return this.execute(RedisCommand.of(Command.LINSERT).put(this.marshaller.encode(key)).put("AFTER").put(this.marshaller.encode(pivot)).put(this.marshaller.encode(element)));
    }

    Uni<Response> _llen(K key) {
        ParameterValidation.nonNull(key, (String)"key");
        return this.execute(RedisCommand.of(Command.LLEN).put(this.marshaller.encode(key)));
    }

    Uni<Response> _lmove(K source, K destination, Position positionInSource, Position positionInDest) {
        ParameterValidation.nonNull(source, (String)"source");
        ParameterValidation.nonNull(destination, (String)"destination");
        ParameterValidation.nonNull((Object)((Object)positionInSource), (String)"positionInSource");
        ParameterValidation.nonNull((Object)((Object)positionInDest), (String)"positionInDest");
        return this.execute(RedisCommand.of(Command.LMOVE).put(this.marshaller.encode(source)).put(this.marshaller.encode(destination)).put(this.marshaller.encode(positionInSource.name())).put(this.marshaller.encode(positionInDest.name())));
    }

    Uni<Response> _lmpop(Position position, K ... keys) {
        ParameterValidation.nonNull((Object)((Object)position), (String)"position");
        Validation.notNullOrEmpty(keys, "keys");
        ParameterValidation.doesNotContainNull((Object[])keys, (String)"keys");
        RedisCommand cmd = RedisCommand.of(Command.LMPOP);
        cmd.put(keys.length);
        cmd.putAll(this.marshaller.encode(keys));
        cmd.put(position.name());
        return this.execute(cmd);
    }

    Uni<Response> _lmpop(Position position, int count, K ... keys) {
        ParameterValidation.nonNull((Object)((Object)position), (String)"position");
        Validation.notNullOrEmpty(keys, "keys");
        ParameterValidation.doesNotContainNull((Object[])keys, (String)"keys");
        ParameterValidation.positive((int)count, (String)"count");
        RedisCommand cmd = RedisCommand.of(Command.LMPOP);
        cmd.put(keys.length);
        cmd.putAll(this.marshaller.encode(keys));
        cmd.put(position.name());
        cmd.put("COUNT").put(count);
        return this.execute(cmd);
    }

    Uni<Response> _lpop(K key) {
        ParameterValidation.nonNull(key, (String)"key");
        return this.execute(RedisCommand.of(Command.LPOP).put(this.marshaller.encode(key)));
    }

    Uni<Response> _lpop(K key, int count) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.positive((int)count, (String)"count");
        return this.execute(RedisCommand.of(Command.LPOP).put(this.marshaller.encode(key)).put(count));
    }

    List<V> decodeListV(Response r) {
        return this.marshaller.decodeAsList(r, this.typeOfValue);
    }

    Uni<Response> _lpos(K key, V element) {
        return this._lpos(key, element, DEFAULT_INSTANCE);
    }

    Uni<Response> _lpos(K key, V element, LPosArgs args) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull(element, (String)"element");
        RedisCommand cmd = RedisCommand.of(Command.LPOS);
        cmd.put(this.marshaller.encode(key));
        cmd.put(this.marshaller.encode(element));
        cmd.putArgs(args);
        return this.execute(cmd);
    }

    Long decodeLongOrNull(Response r) {
        if (r == null) {
            return null;
        }
        return r.toLong();
    }

    Uni<Response> _lpos(K key, V element, int count) {
        return this._lpos(key, element, count, DEFAULT_INSTANCE);
    }

    Uni<Response> _lpos(K key, V element, int count, LPosArgs args) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull(element, (String)"element");
        Validation.positiveOrZero(count, "count");
        RedisCommand cmd = RedisCommand.of(Command.LPOS);
        cmd.put(this.marshaller.encode(key));
        cmd.put(this.marshaller.encode(element));
        cmd.put("COUNT").put(count);
        cmd.putArgs(args);
        return this.execute(cmd);
    }

    List<Long> decodeListOfLongs(Response r) {
        return this.marshaller.decodeAsList(r, Response::toLong);
    }

    Uni<Response> _lpush(K key, V ... elements) {
        ParameterValidation.nonNull(key, (String)"key");
        Validation.notNullOrEmpty(elements, "elements");
        ParameterValidation.doesNotContainNull((Object[])elements, (String)"elements");
        RedisCommand cmd = RedisCommand.of(Command.LPUSH);
        cmd.put(this.marshaller.encode(key)).putAll(this.marshaller.encode(elements));
        return this.execute(cmd);
    }

    Uni<Response> _lpushx(K key, V ... elements) {
        ParameterValidation.nonNull(key, (String)"key");
        Validation.notNullOrEmpty(elements, "elements");
        ParameterValidation.doesNotContainNull((Object[])elements, (String)"elements");
        RedisCommand cmd = RedisCommand.of(Command.LPUSHX);
        cmd.put(this.marshaller.encode(key)).putAll(this.marshaller.encode(elements));
        return this.execute(cmd);
    }

    Uni<Response> _lrange(K key, long start, long stop) {
        ParameterValidation.nonNull(key, (String)"key");
        return this.execute(RedisCommand.of(Command.LRANGE).put(this.marshaller.encode(key)).put(start).put(stop));
    }

    Uni<Response> _lrem(K key, long count, V element) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull(element, (String)"element");
        return this.execute(RedisCommand.of(Command.LREM).put(this.marshaller.encode(key)).put(count).put(this.marshaller.encode(element)));
    }

    Uni<Response> _lset(K key, long index, V element) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull(element, (String)"element");
        return this.execute(RedisCommand.of(Command.LSET).put(this.marshaller.encode(key)).put(index).put(this.marshaller.encode(element)));
    }

    Uni<Response> _ltrim(K key, long start, long stop) {
        ParameterValidation.nonNull(key, (String)"key");
        return this.execute(RedisCommand.of(Command.LTRIM).put(this.marshaller.encode(key)).put(start).put(stop));
    }

    Uni<Response> _rpop(K key) {
        ParameterValidation.nonNull(key, (String)"key");
        return this.execute(RedisCommand.of(Command.RPOP).put(this.marshaller.encode(key)));
    }

    Uni<Response> _rpop(K key, int count) {
        ParameterValidation.nonNull(key, (String)"key");
        return this.execute(RedisCommand.of(Command.RPOP).put(this.marshaller.encode(key)).put(count));
    }

    Uni<Response> _rpoplpush(K source, K destination) {
        ParameterValidation.nonNull(source, (String)"source");
        ParameterValidation.nonNull(destination, (String)"destination");
        return this.execute(RedisCommand.of(Command.RPOPLPUSH).put(this.marshaller.encode(source)).put(this.marshaller.encode(destination)));
    }

    Uni<Response> _rpush(K key, V ... values) {
        ParameterValidation.nonNull(key, (String)"key");
        Validation.notNullOrEmpty(values, "values");
        ParameterValidation.doesNotContainNull((Object[])values, (String)"values");
        RedisCommand cmd = RedisCommand.of(Command.RPUSH);
        cmd.put(this.marshaller.encode(key)).putAll(this.marshaller.encode(values));
        return this.execute(cmd);
    }

    Uni<Response> _rpushx(K key, V ... values) {
        ParameterValidation.nonNull(key, (String)"key");
        Validation.notNullOrEmpty(values, "values");
        ParameterValidation.doesNotContainNull((Object[])values, (String)"values");
        RedisCommand cmd = RedisCommand.of(Command.RPUSHX);
        cmd.put(this.marshaller.encode(key)).putAll(this.marshaller.encode(values));
        return this.execute(cmd);
    }
}

