/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.runtime.datasource;

import io.quarkus.redis.runtime.datasource.AbstractRedisCommands;
import io.quarkus.redis.runtime.datasource.Marshaller;
import io.quarkus.redis.runtime.datasource.RedisCommand;
import io.quarkus.redis.runtime.datasource.RedisCommandExecutor;
import io.quarkus.redis.runtime.datasource.Validation;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.vertx.mutiny.redis.client.Command;
import io.vertx.mutiny.redis.client.Response;
import java.lang.reflect.Type;

class AbstractHyperLogLogCommands<K, V>
extends AbstractRedisCommands {
    AbstractHyperLogLogCommands(RedisCommandExecutor api, Type k, Type v) {
        super(api, new Marshaller(k, v));
    }

    Uni<Response> _pfadd(K key, V ... values) {
        ParameterValidation.nonNull(key, (String)"key");
        Validation.notNullOrEmpty(values, "values");
        ParameterValidation.doesNotContainNull((Object[])values, (String)"values");
        RedisCommand cmd = RedisCommand.of(Command.PFADD).put(this.marshaller.encode(key)).putAll(this.marshaller.encode(values));
        return this.execute(cmd);
    }

    Uni<Response> _pfmerge(K destination, K ... sources) {
        ParameterValidation.nonNull(destination, (String)"destination");
        Validation.notNullOrEmpty(sources, "sources");
        ParameterValidation.doesNotContainNull((Object[])sources, (String)"sources");
        RedisCommand cmd = RedisCommand.of(Command.PFMERGE).put(this.marshaller.encode(destination)).putAll(this.marshaller.encode(sources));
        return this.execute(cmd);
    }

    Uni<Response> _pfcount(K ... keys) {
        Validation.notNullOrEmpty(keys, "keys");
        ParameterValidation.doesNotContainNull((Object[])keys, (String)"keys");
        return this.execute(RedisCommand.of(Command.PFCOUNT).put(this.marshaller.encode(keys)));
    }
}

