/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.proxy.runtime.config;

import io.quarkus.proxy.ProxyType;
import io.quarkus.runtime.annotations.ConfigDocDefault;
import io.quarkus.runtime.annotations.ConfigGroup;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.smallrye.config.ConfigMapping;
import io.smallrye.config.WithDefault;
import io.smallrye.config.WithParentName;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;

@ConfigMapping(prefix="quarkus.proxy")
@ConfigRoot(phase=ConfigPhase.RUN_TIME)
public interface ProxyConfig {
    @WithParentName
    public NamedProxyConfig defaultProxyConfig();

    @WithParentName
    public Map<String, NamedProxyConfig> namedProxyConfigs();

    @ConfigGroup
    public static interface ProxyCredentialProviderConfig {
        public Optional<String> name();

        public Optional<String> beanName();

        @WithDefault(value="user")
        public String usernameKey();

        @WithDefault(value="password")
        public String passwordKey();
    }

    @ConfigGroup
    public static interface NamedProxyConfig {
        public Optional<String> host();

        public OptionalInt port();

        public ProxyCredentialProviderConfig credentialsProvider();

        public Optional<String> username();

        public Optional<String> password();

        public Optional<List<String>> nonProxyHosts();

        @ConfigDocDefault(value="10s")
        public Optional<Duration> proxyConnectTimeout();

        @WithDefault(value="http")
        public ProxyType type();
    }
}

