/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.runtime.logs;

import io.opentelemetry.api.OpenTelemetry;
import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.opentelemetry.runtime.config.runtime.OTelRuntimeConfig;
import io.quarkus.opentelemetry.runtime.logs.OpenTelemetryLogHandler;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.logging.Handler;

@Recorder
public class OpenTelemetryLogRecorder {
    private final RuntimeValue<OTelRuntimeConfig> runtimeConfig;

    public OpenTelemetryLogRecorder(RuntimeValue<OTelRuntimeConfig> runtimeConfig) {
        this.runtimeConfig = runtimeConfig;
    }

    public RuntimeValue<Optional<Handler>> initializeHandler(BeanContainer beanContainer) {
        if (((OTelRuntimeConfig)this.runtimeConfig.getValue()).sdkDisabled() || !((OTelRuntimeConfig)this.runtimeConfig.getValue()).logs().handlerEnabled()) {
            return new RuntimeValue(Optional.empty());
        }
        OpenTelemetry openTelemetry = (OpenTelemetry)beanContainer.beanInstance(OpenTelemetry.class, new Annotation[0]);
        OpenTelemetryLogHandler logHandler = new OpenTelemetryLogHandler(openTelemetry);
        logHandler.setLevel(((OTelRuntimeConfig)this.runtimeConfig.getValue()).logs().level());
        return new RuntimeValue(Optional.of(logHandler));
    }
}

