/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.runtime.logs;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.logs.LogRecordBuilder;
import io.opentelemetry.api.logs.Severity;
import io.opentelemetry.semconv.ExceptionAttributes;
import io.opentelemetry.semconv.incubating.CodeIncubatingAttributes;
import io.opentelemetry.semconv.incubating.LogIncubatingAttributes;
import io.opentelemetry.semconv.incubating.ThreadIncubatingAttributes;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.Instant;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.logmanager.ExtLogRecord;

public class OpenTelemetryLogHandler
extends Handler {
    private final OpenTelemetry openTelemetry;

    public OpenTelemetryLogHandler(OpenTelemetry openTelemetry) {
        this.openTelemetry = openTelemetry;
    }

    @Override
    public void publish(LogRecord record) {
        if (this.openTelemetry == null) {
            return;
        }
        LogRecordBuilder logRecordBuilder = this.openTelemetry.getLogsBridge().loggerBuilder("io.quarkus.opentelemetry").build().logRecordBuilder().setTimestamp(Instant.now()).setObservedTimestamp(record.getInstant());
        if (record.getLevel() != null) {
            logRecordBuilder.setSeverity(this.mapSeverity(record.getLevel())).setSeverityText(record.getLevel().getName());
        }
        if (record.getMessage() != null) {
            logRecordBuilder.setBody(record.getMessage());
        }
        AttributesBuilder attributes = Attributes.builder();
        attributes.put(CodeIncubatingAttributes.CODE_NAMESPACE, (Object)record.getSourceClassName());
        attributes.put(CodeIncubatingAttributes.CODE_FUNCTION, (Object)record.getSourceMethodName());
        if (record instanceof ExtLogRecord) {
            attributes.put(CodeIncubatingAttributes.CODE_LINENO, ((ExtLogRecord)record).getSourceLineNumber());
            attributes.put(ThreadIncubatingAttributes.THREAD_NAME, (Object)((ExtLogRecord)record).getThreadName());
            attributes.put(ThreadIncubatingAttributes.THREAD_ID, (Object)((ExtLogRecord)record).getLongThreadID());
            attributes.put(AttributeKey.stringKey((String)"log.logger.namespace"), (Object)((ExtLogRecord)record).getLoggerClassName());
            Map mdcCopy = ((ExtLogRecord)record).getMdcCopy();
            if (mdcCopy != null) {
                mdcCopy.forEach((k, v) -> {
                    if (!(k.toLowerCase().equals("spanid") || k.toLowerCase().equals("traceid") || k.toLowerCase().equals("sampled"))) {
                        attributes.put(AttributeKey.stringKey((String)k), v);
                    }
                });
            }
        }
        if (record.getThrown() != null) {
            try (StringWriter sw = new StringWriter(1024);
                 PrintWriter pw = new PrintWriter(sw);){
                record.getThrown().printStackTrace(pw);
                sw.flush();
                attributes.put(ExceptionAttributes.EXCEPTION_STACKTRACE, (Object)sw.toString());
            }
            catch (Throwable t) {
                attributes.put(ExceptionAttributes.EXCEPTION_STACKTRACE, (Object)"Unable to get the stacktrace of the exception");
            }
            attributes.put(ExceptionAttributes.EXCEPTION_TYPE, (Object)record.getThrown().getClass().getName());
            attributes.put(ExceptionAttributes.EXCEPTION_MESSAGE, (Object)record.getThrown().getMessage());
        }
        Config config = ConfigProvider.getConfig();
        config.getOptionalValue("quarkus.log.file.enable", Boolean.class).ifPresent(enable -> {
            Optional filePath = config.getOptionalValue("quarkus.log.file.path", String.class);
            if (enable.equals(Boolean.TRUE) && filePath.isPresent()) {
                attributes.put(LogIncubatingAttributes.LOG_FILE_PATH, (Object)((String)filePath.get()));
            }
        });
        logRecordBuilder.setAllAttributes(attributes.build());
        logRecordBuilder.emit();
    }

    private Severity mapSeverity(Level level) {
        if (level.intValue() == Level.SEVERE.intValue()) {
            return Severity.ERROR;
        }
        if (level.intValue() == Level.WARNING.intValue()) {
            return Severity.WARN;
        }
        if (level.intValue() <= Level.INFO.intValue() && level.intValue() >= Level.CONFIG.intValue()) {
            return Severity.INFO;
        }
        if (level.intValue() == Level.FINE.intValue()) {
            return Severity.DEBUG;
        }
        if (level.intValue() <= Level.FINER.intValue()) {
            return Severity.TRACE;
        }
        return Severity.UNDEFINED_SEVERITY_NUMBER;
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws SecurityException {
    }
}

