/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.runtime.tracing;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.trace.data.LinkData;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import io.opentelemetry.sdk.trace.samplers.SamplingResult;
import io.opentelemetry.semconv.SemanticAttributes;
import io.quarkus.opentelemetry.runtime.config.runtime.SemconvStabilityType;
import java.util.List;

public class DropTargetsSampler
implements Sampler {
    private final Sampler sampler;
    private final List<String> dropTargets;
    private final SemconvStabilityType semconvStabilityOptin;

    public DropTargetsSampler(Sampler sampler, List<String> dropTargets, SemconvStabilityType semconvStabilityOptin) {
        this.sampler = sampler;
        this.dropTargets = dropTargets;
        this.semconvStabilityOptin = semconvStabilityOptin;
    }

    public SamplingResult shouldSample(Context parentContext, String traceId, String name, SpanKind spanKind, Attributes attributes, List<LinkData> parentLinks) {
        if (spanKind.equals((Object)SpanKind.SERVER)) {
            Object target;
            if (SemconvStabilityType.HTTP.equals((Object)this.semconvStabilityOptin) || SemconvStabilityType.HTTP_DUP.equals((Object)this.semconvStabilityOptin)) {
                String path = (String)attributes.get(SemanticAttributes.URL_PATH);
                String query = (String)attributes.get(SemanticAttributes.URL_QUERY);
                target = path + (String)(query == null ? "" : "?" + query);
            } else {
                target = (String)attributes.get(SemanticAttributes.HTTP_TARGET);
            }
            if (this.shouldDrop((String)target)) {
                return SamplingResult.drop();
            }
        }
        return this.sampler.shouldSample(parentContext, traceId, name, spanKind, attributes, parentLinks);
    }

    private boolean shouldDrop(String target) {
        if (target == null || target.isEmpty()) {
            return false;
        }
        if (this.safeContains(target)) {
            return true;
        }
        if (target.charAt(target.length() - 1) == '/' && this.safeContains(target.substring(0, target.length() - 1))) {
            return true;
        }
        int lastSlashIndex = target.lastIndexOf(47);
        return lastSlashIndex != -1 && (this.safeContains(target.substring(0, lastSlashIndex) + "*") || this.safeContains(target.substring(0, lastSlashIndex) + "/*"));
    }

    private boolean safeContains(String target) {
        return this.dropTargets.contains(target);
    }

    public String getDescription() {
        return this.sampler.getDescription();
    }
}

