/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.mutiny.deployment;

import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ContextHandlerBuildItem;
import io.quarkus.deployment.builditem.ExecutorBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.mutiny.deployment.MutinyRuntimeInitBuildItem;
import io.quarkus.mutiny.runtime.MutinyInfrastructure;
import io.quarkus.runtime.ShutdownContext;
import java.util.Optional;
import org.jboss.threads.ContextHandler;

public class MutinyProcessor {
    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public MutinyRuntimeInitBuildItem runtimeInit(ExecutorBuildItem executorBuildItem, MutinyInfrastructure recorder, ShutdownContextBuildItem shutdownContext, Optional<ContextHandlerBuildItem> contextHandler) {
        ContextHandler handler = contextHandler.map(ContextHandlerBuildItem::contextHandler).orElse(null);
        recorder.configureMutinyInfrastructure(executorBuildItem.getExecutorProxy(), (ShutdownContext)shutdownContext, handler);
        return new MutinyRuntimeInitBuildItem();
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    public void buildTimeInit(MutinyInfrastructure recorder) {
        recorder.configureDroppedExceptionHandler();
        recorder.configureThreadBlockingChecker();
        recorder.configureOperatorLogger();
    }
}

