/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.mongodb.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.kubernetes.service.binding.spi.ServiceBindingQualifierBuildItem;
import io.quarkus.mongodb.deployment.MongoClientBuildItem;
import io.quarkus.mongodb.deployment.MongoClientBuildTimeConfig;
import java.util.List;

public class MongoBindingProcessor {
    private static final String MONGO = "mongodb";
    private static final String DEFAULT = "<default>";

    @BuildStep
    public void process(MongoClientBuildTimeConfig config, List<MongoClientBuildItem> clients, BuildProducer<ServiceBindingQualifierBuildItem> bindings) {
        clients.forEach(client -> {
            if (DEFAULT.equalsIgnoreCase(client.getName())) {
                bindings.produce((BuildItem)new ServiceBindingQualifierBuildItem(MONGO, MONGO, client.getName()));
            } else {
                bindings.produce((BuildItem)new ServiceBindingQualifierBuildItem(MONGO, client.getName()));
            }
        });
    }
}

