/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.runtime.binder.vertx;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.micrometer.runtime.HttpClientMetricsTagsContributor;
import io.quarkus.micrometer.runtime.binder.HttpBinderConfiguration;
import io.quarkus.micrometer.runtime.binder.HttpCommonTags;
import io.quarkus.micrometer.runtime.binder.RequestMetricInfo;
import io.quarkus.micrometer.runtime.binder.vertx.EventTiming;
import io.quarkus.micrometer.runtime.binder.vertx.IgnorableMetric;
import io.quarkus.micrometer.runtime.binder.vertx.NetworkMetrics;
import io.quarkus.micrometer.runtime.binder.vertx.VertxTcpClientMetrics;
import io.vertx.core.http.WebSocket;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.spi.metrics.ClientMetrics;
import io.vertx.core.spi.metrics.HttpClientMetrics;
import io.vertx.core.spi.observability.HttpRequest;
import io.vertx.core.spi.observability.HttpResponse;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.jboss.logging.Logger;

class VertxHttpClientMetrics
extends VertxTcpClientMetrics
implements HttpClientMetrics<RequestTracker, String, LongTaskTimer.Sample, EventTiming> {
    static final Logger log = Logger.getLogger(VertxHttpClientMetrics.class);
    private final LongAdder queue = new LongAdder();
    private final LongAdder pending = new LongAdder();
    private final Timer queueDelay;
    private final Map<String, LongAdder> webSockets = new ConcurrentHashMap<String, LongAdder>();
    private final HttpBinderConfiguration config;
    private final Meter.MeterProvider<Timer> responseTimes;
    private final List<HttpClientMetricsTagsContributor> httpClientMetricsTagsContributors;

    VertxHttpClientMetrics(MeterRegistry registry, String prefix, Tags tags, HttpBinderConfiguration httpBinderConfiguration) {
        super(registry, prefix, tags);
        this.config = httpBinderConfiguration;
        this.queueDelay = Timer.builder((String)"http.client.queue.delay").description("Time spent in the waiting queue before being processed").tags((Iterable)tags).register(registry);
        Gauge.builder((String)"http.client.queue.size", (Supplier)new Supplier<Number>(){

            @Override
            public Number get() {
                return VertxHttpClientMetrics.this.queue.doubleValue();
            }
        }).description("Number of pending elements in the waiting queue").tags((Iterable)tags).strongReference(true).register(registry);
        Gauge.builder((String)"http.client.pending", (Supplier)new Supplier<Number>(){

            @Override
            public Number get() {
                return VertxHttpClientMetrics.this.pending.longValue();
            }
        }).description("Number of requests waiting for a response");
        this.httpClientMetricsTagsContributors = this.resolveHttpClientMetricsTagsContributors();
        this.responseTimes = Timer.builder((String)this.config.getHttpClientRequestsName()).description("Response times").withRegistry(registry);
    }

    private List<HttpClientMetricsTagsContributor> resolveHttpClientMetricsTagsContributors() {
        List<HttpClientMetricsTagsContributor> httpClientMetricsTagsContributors;
        ArcContainer arcContainer = Arc.container();
        if (arcContainer == null) {
            httpClientMetricsTagsContributors = Collections.emptyList();
        } else {
            List handles = arcContainer.listAll(HttpClientMetricsTagsContributor.class, new Annotation[0]);
            if (handles.isEmpty()) {
                httpClientMetricsTagsContributors = Collections.emptyList();
            } else {
                httpClientMetricsTagsContributors = new ArrayList<HttpClientMetricsTagsContributor>(handles.size());
                for (InstanceHandle handle : handles) {
                    httpClientMetricsTagsContributors.add((HttpClientMetricsTagsContributor)handle.get());
                }
            }
        }
        return httpClientMetricsTagsContributors;
    }

    public ClientMetrics<RequestTracker, EventTiming, HttpRequest, HttpResponse> createEndpointMetrics(SocketAddress remoteAddress, int maxPoolSize) {
        final String remote = NetworkMetrics.toString(remoteAddress);
        return new ClientMetrics<RequestTracker, EventTiming, HttpRequest, HttpResponse>(){

            public EventTiming enqueueRequest() {
                VertxHttpClientMetrics.this.queue.increment();
                return new EventTiming(VertxHttpClientMetrics.this.queueDelay);
            }

            public void dequeueRequest(EventTiming event) {
                VertxHttpClientMetrics.this.queue.decrement();
                event.end();
            }

            public RequestTracker init() {
                return new RequestTracker();
            }

            public void requestBegin(RequestTracker requestMetric, String uri, HttpRequest request) {
                requestMetric.request = request;
                requestMetric.tags = VertxHttpClientMetrics.this.tags.and(new Tag[]{Tag.of((String)"address", (String)remote), HttpCommonTags.method(request.method().name()), HttpCommonTags.uri(request.uri(), null, -1, false)});
                String path = requestMetric.getNormalizedUriPath(VertxHttpClientMetrics.this.config.getServerMatchPatterns(), VertxHttpClientMetrics.this.config.getServerIgnorePatterns());
                if (path != null) {
                    VertxHttpClientMetrics.this.pending.increment();
                    requestMetric.timer = new EventTiming(null);
                }
            }

            public void requestEnd(RequestTracker tracker, long bytesWritten) {
                if (!VertxHttpClientMetrics.this.shouldTrack(tracker)) {
                    return;
                }
                if (tracker.requestEnded()) {
                    VertxHttpClientMetrics.this.pending.decrement();
                }
            }

            public void requestReset(RequestTracker tracker) {
                if (!VertxHttpClientMetrics.this.shouldTrack(tracker)) {
                    return;
                }
                VertxHttpClientMetrics.this.pending.decrement();
                tracker.requestReset();
            }

            public void responseBegin(RequestTracker tracker, HttpResponse response) {
                if (tracker == null) {
                    return;
                }
                tracker.response = response;
            }

            public void responseEnd(RequestTracker tracker, long bytesRead) {
                if (!VertxHttpClientMetrics.this.shouldTrack(tracker)) {
                    return;
                }
                if (tracker.responseEnded()) {
                    VertxHttpClientMetrics.this.pending.decrement();
                }
                long duration = tracker.timer.end();
                Tags list = tracker.tags.and(new Tag[]{HttpCommonTags.status(tracker.response.statusCode())}).and(new Tag[]{HttpCommonTags.outcome(tracker.response.statusCode())});
                if (!VertxHttpClientMetrics.this.httpClientMetricsTagsContributors.isEmpty()) {
                    DefaultContext context = new DefaultContext(tracker.request, tracker.response);
                    for (int i = 0; i < VertxHttpClientMetrics.this.httpClientMetricsTagsContributors.size(); ++i) {
                        try {
                            Tags additionalTags = VertxHttpClientMetrics.this.httpClientMetricsTagsContributors.get(i).contribute(context);
                            list = list.and((Iterable)additionalTags);
                            continue;
                        }
                        catch (Exception e) {
                            log.debug((Object)"Unable to obtain additional tags", (Throwable)e);
                        }
                    }
                }
                ((Timer)VertxHttpClientMetrics.this.responseTimes.withTags((Iterable)list)).record(duration, TimeUnit.NANOSECONDS);
            }
        };
    }

    public String connected(WebSocket webSocket) {
        final String remote = webSocket.remoteAddress().toString();
        this.webSockets.computeIfAbsent(remote, new Function<String, LongAdder>(){

            @Override
            public LongAdder apply(String s) {
                LongAdder count = new LongAdder();
                Gauge.builder((String)VertxHttpClientMetrics.this.config.getHttpClientWebSocketConnectionsName(), count::longValue).description("The number of active web socket connections").tags((Iterable)VertxHttpClientMetrics.this.tags.and("address", remote)).register(VertxHttpClientMetrics.this.registry);
                return count;
            }
        }).increment();
        return remote;
    }

    public void disconnected(String remote) {
        LongAdder adder = this.webSockets.get(remote);
        if (adder != null) {
            adder.decrement();
            if (adder.longValue() == 0L) {
                this.webSockets.remove(remote);
            }
        }
    }

    private boolean shouldTrack(RequestTracker tracker) {
        if (tracker == null || tracker.timer == null) {
            return false;
        }
        return !tracker.isIgnored();
    }

    public static class RequestTracker
    extends RequestMetricInfo
    implements IgnorableMetric {
        Tags tags;
        HttpRequest request;
        private EventTiming timer;
        HttpResponse response;
        private boolean responseEnded;
        private boolean requestEnded;
        private boolean reset;
        private volatile boolean ignored;

        public RequestTracker() {
        }

        RequestTracker(Tags origin, String address, HttpRequest request) {
            this.request = request;
            this.tags = origin.and(new Tag[]{Tag.of((String)"address", (String)address), HttpCommonTags.method(request.method().name()), HttpCommonTags.uri(request.uri(), null, -1, false)});
        }

        void requestReset() {
            this.reset = true;
        }

        boolean requestEnded() {
            this.requestEnded = true;
            return !this.reset && this.responseEnded;
        }

        boolean responseEnded() {
            this.responseEnded = true;
            return !this.reset && this.requestEnded;
        }

        public String getNormalizedUriPath(Map<Pattern, String> serverMatchPatterns, List<Pattern> serverIgnorePatterns) {
            return super.getNormalizedUriPath(serverMatchPatterns, serverIgnorePatterns, this.request.uri());
        }

        @Override
        public void markAsIgnored() {
            this.ignored = true;
        }

        @Override
        public boolean isIgnored() {
            return this.ignored;
        }
    }

    private record DefaultContext(HttpRequest request, HttpResponse response) implements HttpClientMetricsTagsContributor.Context
    {
    }
}

