/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.runtime.binder.vertx;

import io.quarkus.micrometer.runtime.binder.vertx.IgnorableMetric;
import io.quarkus.micrometer.runtime.binder.vertx.VertxMeterBinderAdapter;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.impl.HttpClientRequestInternal;
import java.util.function.Consumer;
import org.eclipse.microprofile.rest.client.RestClientBuilder;
import org.eclipse.microprofile.rest.client.spi.RestClientBuilderListener;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.client.impl.VertxRequestCustomizingClientBuilder;

public class RestClientBuilderMetricsListener
implements RestClientBuilderListener {
    private static final Logger log = Logger.getLogger(VertxMeterBinderAdapter.class);

    public void onNewBuilder(RestClientBuilder builder) {
        if ("io.quarkus.restclient.runtime.QuarkusRestClientBuilder".equals(builder.getClass().getName())) {
            return;
        }
        if (builder instanceof VertxRequestCustomizingClientBuilder) {
            VertxRequestCustomizingClientBuilder vertxRequestCustomizingClientBuilder = (VertxRequestCustomizingClientBuilder)builder;
            vertxRequestCustomizingClientBuilder.httpClientRequestCustomizer((Consumer)new Consumer<HttpClientRequest>(){

                @Override
                public void accept(HttpClientRequest httpClientRequest) {
                    if (httpClientRequest instanceof HttpClientRequestInternal) {
                        HttpClientRequestInternal httpClientRequestInternal = (HttpClientRequestInternal)httpClientRequest;
                        Object metricObj = httpClientRequestInternal.metric();
                        if (metricObj instanceof IgnorableMetric) {
                            IgnorableMetric metric = (IgnorableMetric)metricObj;
                            metric.markAsIgnored();
                        }
                    } else {
                        log.warnf("Unhandled HttpClientRequest type: '%s'. Metrics might not work properly.", (Object)httpClientRequest.getClass().getName());
                    }
                }
            });
        }
    }
}

