/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.runtime.binder;

import io.micrometer.core.instrument.Timer;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.jboss.logging.Logger;

public class RequestMetricInfo {
    static final Logger log = Logger.getLogger(RequestMetricInfo.class);
    public static final String ROOT = "/";
    public static final String HTTP_REQUEST_PATH = "HTTP_REQUEST_PATH";
    protected Timer.Sample sample;

    public RequestMetricInfo setSample(Timer.Sample sample) {
        this.sample = sample;
        return this;
    }

    public Timer.Sample getSample() {
        return this.sample;
    }

    public String getNormalizedUriPath(Map<Pattern, String> matchPatterns, List<Pattern> ignorePatterns, String uri) {
        String origPath;
        String path = RequestMetricInfo.normalizePath(uri);
        if (path.length() > 1 && (path = RequestMetricInfo.applyMatchPatterns(origPath = path, matchPatterns)).equals(origPath)) {
            path = RequestMetricInfo.normalizePath(this.applyTemplateMatching(origPath));
        }
        return RequestMetricInfo.filterIgnored(path, ignorePatterns);
    }

    protected String applyTemplateMatching(String path) {
        return path;
    }

    static String applyMatchPatterns(String path, Map<Pattern, String> matchPatterns) {
        if (!matchPatterns.isEmpty()) {
            for (Map.Entry<Pattern, String> mp : matchPatterns.entrySet()) {
                if (!mp.getKey().matcher(path).matches()) continue;
                log.debugf("Path %s matched pattern %s, using %s", (Object)path, (Object)mp.getKey(), (Object)mp.getValue());
                return mp.getValue();
            }
        }
        return path;
    }

    protected static String filterIgnored(String path, List<Pattern> ignorePatterns) {
        if (!ignorePatterns.isEmpty()) {
            for (Pattern p : ignorePatterns) {
                if (!p.matcher(path).matches()) continue;
                log.debugf("Path %s ignored; matches pattern %s", (Object)path, (Object)p.pattern());
                return null;
            }
        }
        return path;
    }

    protected static String normalizePath(String uri) {
        int end;
        int start;
        if (uri == null || uri.isEmpty() || ROOT.equals(uri)) {
            return ROOT;
        }
        Object workingPath = new String(uri);
        for (start = 0; start < ((String)workingPath).length() && ((String)workingPath).charAt(start) == '/'; ++start) {
        }
        if (start != 1) {
            workingPath = ROOT + ((String)workingPath).substring(start);
        }
        for (end = ((String)workingPath).length(); end > 1 && ((String)workingPath).charAt(end - 1) == '/'; --end) {
        }
        if (end != ((String)workingPath).length()) {
            workingPath = ((String)workingPath).substring(0, end);
        }
        return workingPath;
    }
}

