/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.runtime.binder;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import io.quarkus.arc.Arc;
import io.quarkus.arc.Unremovable;
import io.quarkus.micrometer.runtime.binder.HttpBinderConfiguration;
import io.quarkus.micrometer.runtime.binder.HttpCommonTags;
import io.quarkus.micrometer.runtime.binder.RequestMetricInfo;
import java.lang.annotation.Annotation;
import javax.inject.Inject;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.ext.Provider;

@Unremovable
@Provider
public class RestClientMetricsFilter
implements ClientRequestFilter,
ClientResponseFilter {
    private static final String REQUEST_METRIC_PROPERTY = "restClientMetrics";
    private final MeterRegistry registry = Metrics.globalRegistry;
    private final HttpBinderConfiguration httpMetricsConfig;

    public RestClientMetricsFilter() {
        this((HttpBinderConfiguration)Arc.container().instance(HttpBinderConfiguration.class, new Annotation[0]).get());
    }

    @Inject
    public RestClientMetricsFilter(HttpBinderConfiguration httpMetricsConfig) {
        this.httpMetricsConfig = httpMetricsConfig;
    }

    public void filter(ClientRequestContext requestContext) {
        if (!this.httpMetricsConfig.isClientEnabled()) {
            return;
        }
        RestClientMetricInfo requestMetric = new RestClientMetricInfo(requestContext);
        requestMetric.setSample(Timer.start((MeterRegistry)this.registry));
        requestContext.setProperty(REQUEST_METRIC_PROPERTY, (Object)requestMetric);
    }

    public void filter(ClientRequestContext requestContext, ClientResponseContext responseContext) {
        if (!this.httpMetricsConfig.isClientEnabled()) {
            return;
        }
        RequestMetricInfo requestMetric = this.getRequestMetric(requestContext);
        if (requestMetric != null) {
            String templatePath = (String)requestContext.getProperty("UrlPathTemplate");
            String requestPath = requestMetric.getNormalizedUriPath(this.httpMetricsConfig.getClientMatchPatterns(), this.httpMetricsConfig.getClientIgnorePatterns(), templatePath == null ? requestContext.getUri().getPath() : templatePath);
            if (requestPath != null) {
                Timer.Sample sample = requestMetric.getSample();
                int statusCode = responseContext.getStatus();
                Timer.Builder builder = Timer.builder((String)this.httpMetricsConfig.getHttpClientRequestsName()).tags((Iterable)Tags.of((Tag[])new Tag[]{HttpCommonTags.method(requestContext.getMethod()), HttpCommonTags.uri(requestPath, statusCode), HttpCommonTags.outcome(statusCode), HttpCommonTags.status(statusCode), this.clientName(requestContext)}));
                sample.stop(builder.register(this.registry));
            }
        }
    }

    private RequestMetricInfo getRequestMetric(ClientRequestContext requestContext) {
        return (RequestMetricInfo)requestContext.getProperty(REQUEST_METRIC_PROPERTY);
    }

    private Tag clientName(ClientRequestContext requestContext) {
        String host = requestContext.getUri().getHost();
        if (host == null) {
            host = "none";
        }
        return Tag.of((String)"clientName", (String)host);
    }

    static class RestClientMetricInfo
    extends RequestMetricInfo {
        ClientRequestContext requestContext;

        RestClientMetricInfo(ClientRequestContext requestContext) {
            this.requestContext = requestContext;
        }
    }
}

