/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.deployment.export;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.BuildSteps;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.micrometer.deployment.MicrometerRegistryProviderBuildItem;
import io.quarkus.micrometer.deployment.export.RegistryBuildItem;
import io.quarkus.micrometer.runtime.MicrometerRecorder;
import io.quarkus.micrometer.runtime.config.MicrometerConfig;
import io.quarkus.micrometer.runtime.config.PrometheusConfigGroup;
import io.quarkus.micrometer.runtime.export.PrometheusRecorder;
import io.quarkus.micrometer.runtime.export.exemplars.EmptyExemplarSamplerProvider;
import io.quarkus.micrometer.runtime.export.exemplars.NoopOpenTelemetryExemplarContextUnwrapper;
import io.quarkus.micrometer.runtime.export.exemplars.OpenTelemetryExemplarContextUnwrapper;
import io.quarkus.micrometer.runtime.export.exemplars.OpentelemetryExemplarSamplerProvider;
import io.quarkus.vertx.http.deployment.NonApplicationRootPathBuildItem;
import io.quarkus.vertx.http.deployment.RouteBuildItem;
import io.quarkus.vertx.http.runtime.management.ManagementInterfaceBuildTimeConfig;
import java.util.function.BooleanSupplier;
import org.jboss.logging.Logger;

@BuildSteps(onlyIf={PrometheusEnabled.class})
public class PrometheusRegistryProcessor {
    private static final Logger log = Logger.getLogger(PrometheusRegistryProcessor.class);
    static final String REGISTRY_CLASS_NAME = "io.micrometer.prometheus.PrometheusMeterRegistry";
    static final Class<?> REGISTRY_CLASS = MicrometerRecorder.getClassForName((String)"io.micrometer.prometheus.PrometheusMeterRegistry");

    @BuildStep
    MicrometerRegistryProviderBuildItem createPrometheusRegistry(MicrometerConfig config, BuildProducer<AdditionalBeanBuildItem> additionalBeans) {
        AdditionalBeanBuildItem.Builder builder = AdditionalBeanBuildItem.builder().addBeanClass("io.quarkus.micrometer.runtime.export.PrometheusMeterRegistryProvider").setUnremovable();
        if (config.export().prometheus().defaultRegistry()) {
            builder.addBeanClass("io.quarkus.micrometer.runtime.export.PrometheusMeterRegistryProducer");
        }
        additionalBeans.produce((BuildItem)builder.build());
        return new MicrometerRegistryProviderBuildItem(REGISTRY_CLASS);
    }

    @BuildStep(onlyIf={TraceEnabled.class})
    void registerOpentelemetryExemplarSamplerProvider(BuildProducer<AdditionalBeanBuildItem> additionalBeans) {
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClass(OpentelemetryExemplarSamplerProvider.class).addBeanClass(OpenTelemetryExemplarContextUnwrapper.class).setUnremovable().build());
    }

    @BuildStep(onlyIfNot={TraceEnabled.class})
    void registerEmptyExamplarProvider(BuildProducer<AdditionalBeanBuildItem> additionalBeans) {
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClass(EmptyExemplarSamplerProvider.class).addBeanClass(NoopOpenTelemetryExemplarContextUnwrapper.class).setUnremovable().build());
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void createPrometheusRoute(BuildProducer<RouteBuildItem> routes, BuildProducer<RegistryBuildItem> registries, MicrometerConfig mConfig, NonApplicationRootPathBuildItem nonApplicationRootPathBuildItem, ManagementInterfaceBuildTimeConfig managementBuildTimeConfig, LaunchModeBuildItem launchModeBuildItem, PrometheusRecorder recorder) {
        PrometheusConfigGroup pConfig = mConfig.export().prometheus();
        log.debug((Object)("PROMETHEUS CONFIG: " + String.valueOf(pConfig)));
        routes.produce((BuildItem)nonApplicationRootPathBuildItem.routeBuilder().management().routeFunction(pConfig.path(), recorder.route()).routeConfigKey("quarkus.micrometer.export.prometheus.path").handler(recorder.getHandler()).displayOnNotFoundPage("Metrics").blockingRoute().build());
        routes.produce((BuildItem)nonApplicationRootPathBuildItem.routeBuilder().management().routeFunction(pConfig.path() + (pConfig.path().endsWith("/") ? "*" : "/*"), recorder.route()).handler(recorder.getHandler()).blockingRoute().build());
        routes.produce((BuildItem)nonApplicationRootPathBuildItem.routeBuilder().management().routeFunction(pConfig.path(), recorder.fallbackRoute()).handler(recorder.getFallbackHandler()).build());
        routes.produce((BuildItem)nonApplicationRootPathBuildItem.routeBuilder().management().routeFunction(pConfig.path() + (pConfig.path().endsWith("/") ? "*" : "/*"), recorder.fallbackRoute()).handler(recorder.getFallbackHandler()).build());
        String path = nonApplicationRootPathBuildItem.resolveManagementPath(pConfig.path(), managementBuildTimeConfig, launchModeBuildItem);
        registries.produce((BuildItem)new RegistryBuildItem("Prometheus", path));
    }

    public static class TraceEnabled
    implements BooleanSupplier {
        @Override
        public boolean getAsBoolean() {
            return QuarkusClassLoader.isClassPresentAtRuntime((String)"io.quarkus.opentelemetry.runtime.OpenTelemetryUtil");
        }
    }

    public static class PrometheusEnabled
    implements BooleanSupplier {
        MicrometerConfig mConfig;

        @Override
        public boolean getAsBoolean() {
            return REGISTRY_CLASS != null && QuarkusClassLoader.isClassPresentAtRuntime((String)PrometheusRegistryProcessor.REGISTRY_CLASS_NAME) && this.mConfig.checkRegistryEnabledWithDefault((MicrometerConfig.CapabilityEnabled)this.mConfig.export().prometheus());
        }
    }
}

