/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.logging.json.runtime;

import io.quarkus.logging.json.runtime.AdditionalField;
import io.quarkus.logging.json.runtime.JsonLogConfig;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.jboss.logmanager.ExtLogRecord;
import org.jboss.logmanager.formatters.StructuredFormatter;

public class JsonFormatter
extends org.jboss.logmanager.formatters.JsonFormatter {
    private Set<String> excludedKeys;
    private Map<String, AdditionalField> additionalFields;
    private JsonLogConfig.JsonConfig.LogFormat logFormat = JsonLogConfig.JsonConfig.LogFormat.DEFAULT;
    private String tracePrefix = "";

    public JsonFormatter() {
        this.excludedKeys = new HashSet<String>();
        this.additionalFields = new HashMap<String, AdditionalField>();
    }

    public JsonFormatter(String keyOverrides) {
        super(keyOverrides);
        this.excludedKeys = new HashSet<String>();
        this.additionalFields = new HashMap<String, AdditionalField>();
    }

    public JsonFormatter(String keyOverrides, Set<String> excludedKeys, Map<String, AdditionalField> additionalFields) {
        super(keyOverrides);
        this.excludedKeys = excludedKeys;
        this.additionalFields = additionalFields;
    }

    public Set<String> getExcludedKeys() {
        return this.excludedKeys;
    }

    public void setExcludedKeys(Set<String> excludedKeys) {
        this.excludedKeys = excludedKeys;
    }

    public Map<String, AdditionalField> getAdditionalFields() {
        return this.additionalFields;
    }

    public void setAdditionalFields(Map<String, AdditionalField> additionalFields) {
        this.additionalFields = additionalFields;
    }

    public void setLogFormat(JsonLogConfig.JsonConfig.LogFormat logFormat) {
        this.logFormat = logFormat;
    }

    public void setTracePrefix(String tracePrefix) {
        this.tracePrefix = tracePrefix;
    }

    protected StructuredFormatter.Generator createGenerator(Writer writer) {
        StructuredFormatter.Generator superGenerator = super.createGenerator(writer);
        return new FormatterJsonGenerator(superGenerator, this.excludedKeys);
    }

    protected void after(StructuredFormatter.Generator generator, ExtLogRecord record) throws Exception {
        if (this.logFormat.equals((Object)JsonLogConfig.JsonConfig.LogFormat.GCP)) {
            Map mdcCopy = record.getMdcCopy();
            if (!mdcCopy.isEmpty()) {
                HashMap<String, AdditionalField> current = new HashMap<String, AdditionalField>(this.additionalFields);
                current.computeIfPresent(AdditionalKey.TRACE.getKey(), (key, value) -> {
                    String traceId = (String)mdcCopy.get("traceId");
                    if (traceId != null && !traceId.isEmpty()) {
                        return new AdditionalField(this.tracePrefix + traceId, JsonLogConfig.AdditionalFieldConfig.Type.STRING);
                    }
                    return value;
                });
                current.computeIfPresent(AdditionalKey.SPAN_ID.getKey(), (key, value) -> new AdditionalField(Optional.ofNullable((String)mdcCopy.get("spanId")).orElse(""), JsonLogConfig.AdditionalFieldConfig.Type.STRING));
                current.computeIfPresent(AdditionalKey.TRACE_SAMPLED.getKey(), (key, value) -> new AdditionalField(Optional.ofNullable((String)mdcCopy.get("sampled")).orElse(""), JsonLogConfig.AdditionalFieldConfig.Type.STRING));
                this.addToGenerator(current, generator);
            } else {
                this.addToGenerator(this.additionalFields, generator);
            }
        } else {
            this.addToGenerator(this.additionalFields, generator);
        }
    }

    private void addToGenerator(Map<String, AdditionalField> fields, StructuredFormatter.Generator generator) throws Exception {
        for (Map.Entry<String, AdditionalField> entry : fields.entrySet()) {
            switch (entry.getValue().type()) {
                case STRING: {
                    generator.add(entry.getKey(), entry.getValue().value());
                    break;
                }
                case INT: {
                    generator.add(entry.getKey(), Integer.valueOf(entry.getValue().value()).intValue());
                    break;
                }
                case LONG: {
                    generator.add(entry.getKey(), Long.valueOf(entry.getValue().value()).longValue());
                }
            }
        }
    }

    private static class FormatterJsonGenerator
    implements StructuredFormatter.Generator {
        private final StructuredFormatter.Generator generator;
        private final Set<String> excludedKeys;

        private FormatterJsonGenerator(StructuredFormatter.Generator generator, Set<String> excludedKeys) {
            this.generator = generator;
            this.excludedKeys = excludedKeys;
        }

        public StructuredFormatter.Generator begin() throws Exception {
            this.generator.begin();
            return this;
        }

        public StructuredFormatter.Generator add(String key, int value) throws Exception {
            if (!this.excludedKeys.contains(key)) {
                this.generator.add(key, value);
            }
            return this;
        }

        public StructuredFormatter.Generator add(String key, long value) throws Exception {
            if (!this.excludedKeys.contains(key)) {
                this.generator.add(key, value);
            }
            return this;
        }

        public StructuredFormatter.Generator add(String key, Map<String, ?> value) throws Exception {
            if (!this.excludedKeys.contains(key)) {
                this.generator.add(key, value);
            }
            return this;
        }

        public StructuredFormatter.Generator add(String key, String value) throws Exception {
            if (!this.excludedKeys.contains(key)) {
                this.generator.add(key, value);
            }
            return this;
        }

        public StructuredFormatter.Generator startObject(String key) throws Exception {
            this.generator.startObject(key);
            return this;
        }

        public StructuredFormatter.Generator endObject() throws Exception {
            this.generator.endObject();
            return this;
        }

        public StructuredFormatter.Generator startArray(String key) throws Exception {
            this.generator.startArray(key);
            return this;
        }

        public StructuredFormatter.Generator endArray() throws Exception {
            this.generator.endArray();
            return this;
        }

        public StructuredFormatter.Generator end() throws Exception {
            this.generator.end();
            return this;
        }
    }

    public static enum AdditionalKey {
        ECS_VERSION("ecs.version"),
        DATA_STREAM_TYPE("data_stream.type"),
        SERVICE_NAME("service.name"),
        SERVICE_VERSION("service.version"),
        SERVICE_ENVIRONMENT("service.environment"),
        TRACE("trace"),
        SPAN_ID("spanId"),
        TRACE_SAMPLED("traceSampled");

        private final String key;

        private AdditionalKey(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }
}

