/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.liquibase.runtime;

import io.quarkus.datasource.common.runtime.DataSourceUtil;
import io.quarkus.liquibase.LiquibaseFactory;
import io.quarkus.liquibase.runtime.LiquibaseBuildTimeConfig;
import io.quarkus.liquibase.runtime.LiquibaseCreator;
import io.quarkus.liquibase.runtime.LiquibaseDataSourceBuildTimeConfig;
import io.quarkus.liquibase.runtime.LiquibaseDataSourceRuntimeConfig;
import io.quarkus.liquibase.runtime.LiquibaseRuntimeConfig;
import javax.sql.DataSource;

public class LiquibaseFactoryProducer {
    private final LiquibaseBuildTimeConfig liquibaseBuildTimeConfig;
    private final LiquibaseRuntimeConfig liquibaseRuntimeConfig;

    public LiquibaseFactoryProducer(LiquibaseBuildTimeConfig liquibaseBuildTimeConfig, LiquibaseRuntimeConfig liquibaseRuntimeConfig) {
        this.liquibaseBuildTimeConfig = liquibaseBuildTimeConfig;
        this.liquibaseRuntimeConfig = liquibaseRuntimeConfig;
    }

    public LiquibaseFactory createLiquibaseFactory(DataSource dataSource, String dataSourceName) {
        LiquibaseDataSourceBuildTimeConfig matchingBuildTimeConfig = DataSourceUtil.isDefault((String)dataSourceName) ? this.liquibaseBuildTimeConfig.defaultDataSource : this.liquibaseBuildTimeConfig.getConfigForDataSourceName(dataSourceName);
        LiquibaseDataSourceRuntimeConfig matchingRuntimeConfig = DataSourceUtil.isDefault((String)dataSourceName) ? this.liquibaseRuntimeConfig.defaultDataSource : this.liquibaseRuntimeConfig.getConfigForDataSourceName(dataSourceName);
        return new LiquibaseCreator(matchingRuntimeConfig, matchingBuildTimeConfig).createLiquibaseFactory(dataSource, dataSourceName);
    }
}

