/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.junit.internal;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.collections.MapConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Set;

public class CustomMapEntryConverter
extends MapConverter {
    private final Set<String> SUPPORTED_CLASS_NAMES = Set.of(Map.entry(Integer.MAX_VALUE, Integer.MAX_VALUE).getClass().getName());

    public CustomMapEntryConverter(Mapper mapper) {
        super(mapper);
    }

    public boolean canConvert(Class type) {
        return type != null && this.SUPPORTED_CLASS_NAMES.contains(type.getName());
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        String entryName = this.mapper().serializedClass(Map.Entry.class);
        Map.Entry entry = (Map.Entry)source;
        writer.startNode(entryName);
        this.writeCompleteItem(entry.getKey(), context, writer);
        this.writeCompleteItem(entry.getValue(), context, writer);
        writer.endNode();
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        reader.moveDown();
        Object key = this.readCompleteItem(reader, context, null);
        Object value = this.readCompleteItem(reader, context, null);
        reader.moveUp();
        return new AbstractMap.SimpleEntry<Object, Object>(key, value);
    }
}

