/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.junit.nativeimage;

import java.io.File;
import java.io.FileNotFoundException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;
import java.util.Scanner;
import java.util.Set;
import java.util.TreeSet;
import org.junit.jupiter.api.Assertions;

public final class ClassInclusionReport {
    private final Set<String> includedClasses;
    private final Path usedClassesReport;

    private ClassInclusionReport(Set<String> includedClasses, Path usedClassesReport) {
        this.includedClasses = includedClasses;
        this.usedClassesReport = usedClassesReport;
    }

    public static ClassInclusionReport load() {
        Path usedClassesReport = ClassInclusionReport.getUsedClassesReport();
        TreeSet<String> set = new TreeSet<String>();
        try (Scanner scanner = new Scanner(usedClassesReport.toFile());){
            while (scanner.hasNextLine()) {
                String[] line = scanner.nextLine().split(":");
                set.add(line[line.length - 1]);
            }
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Could not load used classes report", e);
        }
        return new ClassInclusionReport(set, usedClassesReport);
    }

    public void assertContains(Class<?> type) {
        this.assertContains(type.getName());
    }

    public void assertContainsNot(Class<?> type) {
        this.assertContainsNot(type.getName());
    }

    public void assertContains(String typeName) {
        boolean contains = this.includedClasses.contains(typeName);
        if (!contains) {
            Assertions.fail((String)("Type '" + typeName + "' was not found in the report in " + String.valueOf(this.usedClassesReport)));
        }
    }

    public void assertContainsNot(String typeName) {
        boolean contains = this.includedClasses.contains(typeName);
        if (contains) {
            Assertions.fail((String)("Type '" + typeName + "' was found in the report in " + String.valueOf(this.usedClassesReport)));
        }
    }

    private static Path getUsedClassesReport() {
        Path reportsPath = ClassInclusionReport.nativeImageReportsPath();
        File[] usedClassesReports = reportsPath.toFile().listFiles((dir, name) -> name.toLowerCase(Locale.ROOT).startsWith("used_classes_"));
        Assertions.assertNotNull((Object)usedClassesReports, (String)"Could not identify the native image build directory");
        Assertions.assertEquals((int)1, (int)usedClassesReports.length, (String)"Could not identify the native image build directory");
        return usedClassesReports[0].toPath();
    }

    private static Path nativeImageReportsPath() {
        Path nativeBuildPath = ClassInclusionReport.locateNativeImageBuildDirectory();
        Path reportsPath = nativeBuildPath.resolve("reports");
        Assertions.assertTrue((boolean)reportsPath.toFile().exists(), (String)"The reports directory doesn't exist?! Make sure this build was invoked with 'quarkus.native.enable-reports=true'");
        return reportsPath;
    }

    private static Path locateNativeImageBuildDirectory() {
        Path buildPath = Paths.get("target", new String[0]);
        File[] files = buildPath.toFile().listFiles((dir, name) -> name.toLowerCase(Locale.ROOT).endsWith("-native-image-source-jar"));
        Assertions.assertNotNull((Object)files, (String)"Could not identify the native image build directory");
        Assertions.assertEquals((int)1, (int)files.length, (String)"Could not identify the native image build directory");
        return files[0].toPath();
    }
}

