/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.junit.launcher;

import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Optional;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;

public class ExecutionListener
implements TestExecutionListener {
    private final Deque<ClassLoader> origCl = new ArrayDeque<ClassLoader>();

    public void executionStarted(TestIdentifier testIdentifier) {
        ClassSource cs;
        ClassLoader classLoader;
        TestSource source;
        Optional oSource = testIdentifier.getSource();
        if (oSource.isPresent() && (source = (TestSource)oSource.get()) instanceof ClassSource && ExecutionListener.isQuarkusTest(classLoader = (cs = (ClassSource)source).getJavaClass().getClassLoader())) {
            this.origCl.push(Thread.currentThread().getContextClassLoader());
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult result) {
        ClassLoader cl;
        ClassSource cs;
        ClassLoader classLoader;
        TestSource source;
        Optional oSource = testIdentifier.getSource();
        if (oSource.isPresent() && (source = (TestSource)oSource.get()) instanceof ClassSource && ExecutionListener.isQuarkusTest(classLoader = (cs = (ClassSource)source).getJavaClass().getClassLoader()) && (cl = this.origCl.pop()) != null) {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    private static boolean isQuarkusTest(ClassLoader classLoader) {
        return classLoader instanceof QuarkusClassLoader;
    }
}

