/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.junit.launcher;

import io.quarkus.test.junit.classloading.FacadeClassLoader;
import org.junit.platform.launcher.LauncherDiscoveryListener;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.LauncherInterceptor;

public class CustomLauncherInterceptor
implements LauncherDiscoveryListener,
LauncherInterceptor {
    private static FacadeClassLoader facadeLoader = null;
    private static ClassLoader origCl = null;

    private static boolean isProductionModeTests() {
        return System.getProperty("prod.mode.tests") != null;
    }

    public <T> T intercept(LauncherInterceptor.Invocation<T> invocation) {
        if (CustomLauncherInterceptor.isProductionModeTests()) {
            return (T)invocation.proceed();
        }
        return this.actuallyIntercept(invocation);
    }

    private <T> T actuallyIntercept(LauncherInterceptor.Invocation<T> invocation) {
        if (origCl == null) {
            origCl = Thread.currentThread().getContextClassLoader();
        }
        ClassLoader currentCl = Thread.currentThread().getContextClassLoader();
        this.initializeFacadeClassLoader();
        this.adjustContextClassLoader();
        return (T)invocation.proceed();
    }

    private void initializeFacadeClassLoader() {
        ClassLoader currentCl = Thread.currentThread().getContextClassLoader();
        if ((currentCl == null || currentCl != facadeLoader && !currentCl.getClass().getName().equals(FacadeClassLoader.class.getName())) && facadeLoader == null) {
            facadeLoader = new FacadeClassLoader(currentCl);
        }
    }

    public void launcherDiscoveryStarted(LauncherDiscoveryRequest request) {
        if (!CustomLauncherInterceptor.isProductionModeTests()) {
            this.adjustContextClassLoader();
        }
    }

    private void adjustContextClassLoader() {
        ClassLoader currentCl = Thread.currentThread().getContextClassLoader();
        if (currentCl == null || currentCl != facadeLoader && !currentCl.getClass().getName().equals(FacadeClassLoader.class.getName())) {
            Thread.currentThread().setContextClassLoader(facadeLoader);
        }
    }

    public void launcherDiscoveryFinished(LauncherDiscoveryRequest request) {
        if (!facadeLoader.isServiceLoaderMechanism()) {
            Thread.currentThread().setContextClassLoader(origCl);
        }
    }

    public void close() {
        try {
            if (facadeLoader != null) {
                if (Thread.currentThread().getContextClassLoader() == facadeLoader) {
                    Thread.currentThread().setContextClassLoader(origCl);
                }
                facadeLoader.close();
                facadeLoader = null;
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to close custom classloader", e);
        }
    }
}

