/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.junit;

import io.quarkus.bootstrap.app.CuratedApplication;
import io.quarkus.bootstrap.app.QuarkusBootstrap;
import io.quarkus.bootstrap.logging.InitialConfigurator;
import io.quarkus.runtime.logging.JBossVersion;
import io.quarkus.runtime.test.TestHttpEndpointProvider;
import io.quarkus.test.common.ArtifactLauncher;
import io.quarkus.test.common.DevServicesContext;
import io.quarkus.test.common.LauncherUtil;
import io.quarkus.test.common.PropertyTestUtil;
import io.quarkus.test.common.RestAssuredURLManager;
import io.quarkus.test.common.RunCommandLauncher;
import io.quarkus.test.common.TestConfigUtil;
import io.quarkus.test.common.TestResourceManager;
import io.quarkus.test.common.TestScopeManager;
import io.quarkus.test.junit.AbstractQuarkusTestWithContextExtension;
import io.quarkus.test.junit.AbstractTestWithCallbacksExtension;
import io.quarkus.test.junit.ArtifactTypeUtil;
import io.quarkus.test.junit.IntegrationTestExtensionState;
import io.quarkus.test.junit.IntegrationTestUtil;
import io.quarkus.test.junit.QuarkusTestExtension;
import io.quarkus.test.junit.QuarkusTestExtensionState;
import io.quarkus.test.junit.QuarkusTestProfile;
import io.quarkus.test.junit.TestProfileAndProperties;
import io.quarkus.test.junit.TestResourceUtil;
import io.quarkus.test.junit.callback.QuarkusTestMethodContext;
import io.quarkus.test.junit.launcher.ArtifactLauncherProvider;
import java.io.Closeable;
import java.io.File;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.Config;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.BeforeTestExecutionCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;
import org.opentest4j.TestAbortedException;

public class QuarkusIntegrationTestExtension
extends AbstractQuarkusTestWithContextExtension
implements BeforeTestExecutionCallback,
AfterTestExecutionCallback,
BeforeEachCallback,
AfterEachCallback,
BeforeAllCallback,
AfterAllCallback,
TestInstancePostProcessor {
    private static final String ENABLED_CALLBACKS_PROPERTY = "quarkus.test.enable-callbacks-for-integration-tests";
    private static boolean failedBoot;
    private static List<Function<Class<?>, String>> testHttpEndpointProviders;
    private static boolean ssl;
    private static Class<? extends QuarkusTestProfile> quarkusTestProfile;
    private static Throwable firstException;
    private static Class<?> currentJUnitTestClass;
    private static Map<String, String> devServicesProps;
    private static String containerNetworkId;

    public void afterTestExecution(ExtensionContext context) throws Exception {
        if (!failedBoot && !this.isAfterTestCallbacksEmpty()) {
            this.invokeAfterTestExecutionCallbacks(this.createQuarkusTestMethodContext(context));
        }
    }

    public void afterEach(ExtensionContext context) throws Exception {
        if (!failedBoot) {
            if (!this.isAfterEachCallbacksEmpty()) {
                this.invokeAfterEachCallbacks(this.createQuarkusTestMethodContext(context));
            }
            RestAssuredURLManager.clearURL();
            TestScopeManager.tearDown((boolean)true);
        }
    }

    public void beforeTestExecution(ExtensionContext context) throws Exception {
        if (!failedBoot) {
            if (!this.isBeforeTestCallbacksEmpty()) {
                this.invokeBeforeTestExecutionCallbacks(this.createQuarkusTestMethodContext(context));
            }
        } else {
            this.throwBootFailureException();
        }
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        if (failedBoot) {
            this.throwBootFailureException();
        } else {
            if (!this.isBeforeEachCallbacksEmpty()) {
                this.invokeBeforeEachCallbacks(this.createQuarkusTestMethodContext(context));
            }
            RestAssuredURLManager.setURL((boolean)ssl, (String)QuarkusTestExtension.getEndpointPath(context, testHttpEndpointProviders));
            TestScopeManager.setup((boolean)true);
        }
    }

    public void beforeAll(ExtensionContext context) throws Exception {
        this.ensureStarted(context);
        this.invokeBeforeClassCallbacks(context.getRequiredTestClass());
    }

    public void afterAll(ExtensionContext context) throws Exception {
        if (!failedBoot && !this.isAfterAllCallbacksEmpty()) {
            this.invokeAfterAllCallbacks(this.createQuarkusTestMethodContext(context));
        }
    }

    private QuarkusTestExtensionState ensureStarted(ExtensionContext extensionContext) {
        boolean isNewTestClass;
        Class testClass = extensionContext.getRequiredTestClass();
        IntegrationTestUtil.ensureNoInjectAnnotationIsUsed(testClass);
        Properties quarkusArtifactProperties = IntegrationTestUtil.readQuarkusArtifactProperties(extensionContext);
        QuarkusTestExtensionState state = this.getState(extensionContext);
        Class<? extends QuarkusTestProfile> selectedProfile = IntegrationTestUtil.findProfile(testClass);
        boolean wrongProfile = !Objects.equals(selectedProfile, quarkusTestProfile);
        boolean bl = isNewTestClass = !Objects.equals(extensionContext.getRequiredTestClass(), currentJUnitTestClass);
        if (isNewTestClass && state != null) {
            state.setTestFailed(null);
            currentJUnitTestClass = extensionContext.getRequiredTestClass();
        }
        boolean reloadTestResources = false;
        if (state == null && !failedBoot || wrongProfile || (reloadTestResources = isNewTestClass && TestResourceUtil.testResourcesRequireReload(state, extensionContext.getRequiredTestClass(), selectedProfile))) {
            if ((wrongProfile || reloadTestResources) && state != null) {
                try {
                    state.close();
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
            try {
                state = this.doProcessStart(quarkusArtifactProperties, selectedProfile, extensionContext);
                this.setState(extensionContext, state);
            }
            catch (Throwable e) {
                try {
                    Path appLogPath = PropertyTestUtil.getLogFilePath();
                    File appLogFile = appLogPath.toFile();
                    if (appLogFile.exists() && appLogFile.length() > 0L) {
                        System.err.println("Failed to launch the application. The application logs can be found at: " + appLogPath.toAbsolutePath());
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                failedBoot = true;
                firstException = e;
            }
        }
        return state;
    }

    private QuarkusTestExtensionState doProcessStart(Properties quarkusArtifactProperties, Class<? extends QuarkusTestProfile> profile, ExtensionContext context) throws Throwable {
        JBossVersion.disableVersionLogging();
        String artifactType = IntegrationTestUtil.getArtifactType(quarkusArtifactProperties);
        Config config = LauncherUtil.installAndGetSomeConfig();
        String testProfile = TestConfigUtil.integrationTestProfile((Config)config);
        boolean isDockerLaunch = ArtifactTypeUtil.isContainer(artifactType) || ArtifactTypeUtil.isJar(artifactType) && "test-with-native-agent".equals(testProfile);
        ArtifactLauncher.InitContext.DevServicesLaunchResult devServicesLaunchResult = IntegrationTestUtil.handleDevServices(context, isDockerLaunch);
        devServicesProps = devServicesLaunchResult.properties();
        containerNetworkId = devServicesLaunchResult.networkId();
        quarkusTestProfile = profile;
        currentJUnitTestClass = context.getRequiredTestClass();
        TestResourceManager testResourceManager = null;
        try {
            Class requiredTestClass = context.getRequiredTestClass();
            Map<String, String> sysPropRestore = IntegrationTestUtil.getSysPropsToRestore();
            for (String devServicesProp : devServicesProps.keySet()) {
                sysPropRestore.put(devServicesProp, null);
            }
            TestProfileAndProperties testProfileAndProperties = IntegrationTestUtil.determineTestProfileAndProperties(profile, sysPropRestore);
            testResourceManager = new TestResourceManager(requiredTestClass, quarkusTestProfile, TestResourceUtil.TestResourceManagerReflections.copyEntriesFromProfile(testProfileAndProperties.testProfile, context.getRequiredTestClass().getClassLoader()), testProfileAndProperties.testProfile != null && testProfileAndProperties.testProfile.disableGlobalTestResources(), devServicesProps, containerNetworkId == null ? Optional.empty() : Optional.of(containerNetworkId));
            testResourceManager.init(testProfileAndProperties.testProfile != null ? testProfileAndProperties.testProfile.getClass().getName() : null);
            if (this.isCallbacksEnabledForIntegrationTests()) {
                this.populateCallbacks(requiredTestClass.getClassLoader());
            }
            HashMap<String, String> additionalProperties = new HashMap<String, String>();
            Properties existingSysProps = System.getProperties();
            for (String name : existingSysProps.stringPropertyNames()) {
                if (!name.startsWith("quarkus.")) continue;
                additionalProperties.put(name, existingSysProps.getProperty(name));
            }
            additionalProperties.putAll(testProfileAndProperties.properties);
            HashMap<String, String> resourceManagerProps = new HashMap<String, String>(devServicesProps);
            resourceManagerProps.putAll(testResourceManager.start());
            final HashMap<String, String> old = new HashMap<String, String>();
            for (Map.Entry i : resourceManagerProps.entrySet()) {
                old.put((String)i.getKey(), System.getProperty((String)i.getKey()));
                if (i.getValue() == null) {
                    System.clearProperty((String)i.getKey());
                    continue;
                }
                System.setProperty((String)i.getKey(), (String)i.getValue());
            }
            context.getStore(ExtensionContext.Namespace.GLOBAL).put((Object)(QuarkusIntegrationTestExtension.class.getName() + ".systemProps"), (Object)new ExtensionContext.Store.CloseableResource(){

                public void close() throws Throwable {
                    for (Map.Entry i : old.entrySet()) {
                        old.put((String)i.getKey(), System.getProperty((String)i.getKey()));
                        if (i.getValue() == null) {
                            System.clearProperty((String)i.getKey());
                            continue;
                        }
                        System.setProperty((String)i.getKey(), (String)i.getValue());
                    }
                }
            });
            additionalProperties.putAll(resourceManagerProps);
            RunCommandLauncher launcher = null;
            String testHost = System.getProperty("quarkus.http.test-host");
            if (testHost != null && !testHost.isEmpty()) {
                launcher = new RunCommandLauncher();
            } else {
                Duration waitDuration = TestConfigUtil.waitTimeValue((Config)config);
                String target = TestConfigUtil.runTarget((Config)config);
                launcher = RunCommandLauncher.tryLauncher((QuarkusBootstrap)devServicesLaunchResult.getCuratedApplication().getQuarkusBootstrap(), (String)target, (Duration)waitDuration);
                if (launcher == null) {
                    ServiceLoader<ArtifactLauncherProvider> loader = ServiceLoader.load(ArtifactLauncherProvider.class);
                    for (ArtifactLauncherProvider launcherProvider : loader) {
                        if (!launcherProvider.supportsArtifactType(artifactType, testProfile)) continue;
                        launcher = launcherProvider.create(new DefaultArtifactLauncherCreateContext(quarkusArtifactProperties, context, requiredTestClass, devServicesLaunchResult));
                        break;
                    }
                }
            }
            if (launcher == null) {
                throw new IllegalStateException("Artifact type + '" + artifactType + "' is not supported by @QuarkusIntegrationTest");
            }
            IntegrationTestUtil.activateLogging();
            IntegrationTestUtil.startLauncher((ArtifactLauncher)launcher, additionalProperties, () -> {
                ssl = true;
            });
            IntegrationTestExtensionStateResource resource = new IntegrationTestExtensionStateResource((ArtifactLauncher<?>)launcher, devServicesLaunchResult.getCuratedApplication());
            IntegrationTestExtensionState state = new IntegrationTestExtensionState(testResourceManager, resource, AbstractTestWithCallbacksExtension::clearCallbacks, sysPropRestore);
            testHttpEndpointProviders = TestHttpEndpointProvider.load();
            return state;
        }
        catch (Throwable e) {
            if (!InitialConfigurator.DELAYED_HANDLER.isActivated()) {
                IntegrationTestUtil.activateLogging();
            }
            try {
                if (testResourceManager != null) {
                    testResourceManager.close();
                }
            }
            catch (Exception ex) {
                e.addSuppressed(ex);
            }
            throw e;
        }
    }

    public void postProcessTestInstance(Object testInstance, ExtensionContext context) {
        this.ensureStarted(context);
        if (!failedBoot) {
            IntegrationTestUtil.doProcessTestInstance(testInstance, context);
            this.injectTestContext(testInstance);
        }
    }

    private void injectTestContext(Object testInstance) {
        for (Class<?> c = testInstance.getClass(); c != Object.class; c = c.getSuperclass()) {
            for (Field f : c.getDeclaredFields()) {
                if (f.getType().equals(DevServicesContext.class)) {
                    try {
                        f.setAccessible(true);
                        f.set(testInstance, this.createTestContext());
                        return;
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Unable to set field '" + f.getName() + "' with the proper test context", e);
                    }
                }
                if (!DevServicesContext.ContextAware.class.isAssignableFrom(f.getType())) continue;
                f.setAccessible(true);
                try {
                    DevServicesContext.ContextAware val = (DevServicesContext.ContextAware)f.get(testInstance);
                    val.setIntegrationTestContext(this.createTestContext());
                }
                catch (Exception e) {
                    throw new RuntimeException("Unable to inject context into field " + f.getName(), e);
                }
            }
        }
    }

    private DevServicesContext createTestContext() {
        Map<String, String> devServicesPropsCopy = devServicesProps.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(devServicesProps);
        return new DefaultQuarkusIntegrationTestContext(devServicesPropsCopy, containerNetworkId == null ? Optional.empty() : Optional.of(containerNetworkId));
    }

    private void throwBootFailureException() {
        if (firstException != null) {
            Throwable throwable = firstException;
            firstException = null;
            throw new RuntimeException(throwable);
        }
        throw new TestAbortedException("Boot failed");
    }

    private boolean isCallbacksEnabledForIntegrationTests() {
        return Optional.ofNullable(System.getProperty(ENABLED_CALLBACKS_PROPERTY)).map(Boolean::parseBoolean).or(() -> LauncherUtil.installAndGetSomeConfig().getOptionalValue(ENABLED_CALLBACKS_PROPERTY, Boolean.class)).orElse(false);
    }

    private QuarkusTestMethodContext createQuarkusTestMethodContext(ExtensionContext context) {
        Object testInstance = context.getTestInstance().orElse(null);
        List<Object> outerInstances = context.getTestInstances().map(testInstances -> testInstances.getAllInstances().stream().filter(instance -> instance != testInstance).collect(Collectors.toList())).orElse(Collections.emptyList());
        return new QuarkusTestMethodContext(testInstance, outerInstances, context.getTestMethod().orElse(null), this.getState(context).getTestErrorCause());
    }

    private static class DefaultArtifactLauncherCreateContext
    implements ArtifactLauncherProvider.CreateContext {
        private final Properties quarkusArtifactProperties;
        private final ExtensionContext context;
        private final Class<?> requiredTestClass;
        private final ArtifactLauncher.InitContext.DevServicesLaunchResult devServicesLaunchResult;

        DefaultArtifactLauncherCreateContext(Properties quarkusArtifactProperties, ExtensionContext context, Class<?> requiredTestClass, ArtifactLauncher.InitContext.DevServicesLaunchResult devServicesLaunchResult) {
            this.quarkusArtifactProperties = quarkusArtifactProperties;
            this.context = context;
            this.requiredTestClass = requiredTestClass;
            this.devServicesLaunchResult = devServicesLaunchResult;
        }

        @Override
        public Properties quarkusArtifactProperties() {
            return this.quarkusArtifactProperties;
        }

        @Override
        public Path buildOutputDirectory() {
            return IntegrationTestUtil.determineBuildOutputDirectory(this.context);
        }

        @Override
        public Class<?> testClass() {
            return this.requiredTestClass;
        }

        @Override
        public ArtifactLauncher.InitContext.DevServicesLaunchResult devServicesLaunchResult() {
            return this.devServicesLaunchResult;
        }
    }

    private static final class IntegrationTestExtensionStateResource
    implements Closeable {
        private final ArtifactLauncher<?> launcher;
        private final CuratedApplication curatedApplication;

        public IntegrationTestExtensionStateResource(ArtifactLauncher<?> launcher, CuratedApplication curatedApplication) {
            this.launcher = launcher;
            this.curatedApplication = curatedApplication;
        }

        @Override
        public void close() {
            if (this.launcher != null) {
                try {
                    this.launcher.close();
                }
                catch (Exception e) {
                    System.err.println("Unable to close ArtifactLauncher: " + e.getMessage());
                }
            }
            try {
                this.curatedApplication.close();
            }
            catch (Exception e) {
                System.err.println("Unable to close CuratedApplication: " + e.getMessage());
            }
        }
    }

    private static class DefaultQuarkusIntegrationTestContext
    implements DevServicesContext {
        private final Map<String, String> devServicesProperties;
        private final Optional<String> containerNetworkId;

        private DefaultQuarkusIntegrationTestContext(Map<String, String> devServicesProperties, Optional<String> containerNetworkId) {
            this.devServicesProperties = devServicesProperties;
            this.containerNetworkId = containerNetworkId;
        }

        public Map<String, String> devServicesProperties() {
            return this.devServicesProperties;
        }

        public Optional<String> containerNetworkId() {
            return this.containerNetworkId;
        }
    }
}

