/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.config;

import io.quarkus.deployment.dev.testing.TestConfigCustomizer;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.configuration.ConfigUtils;
import io.smallrye.config.SmallRyeConfig;
import io.smallrye.config.SmallRyeConfigBuilder;
import io.smallrye.config.SmallRyeConfigBuilderCustomizer;
import io.smallrye.config.SmallRyeConfigProviderResolver;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;

public class TestConfigProviderResolver
extends SmallRyeConfigProviderResolver {
    private final SmallRyeConfigProviderResolver resolver = (SmallRyeConfigProviderResolver)SmallRyeConfigProviderResolver.instance();
    private final ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
    private final Map<LaunchMode, SmallRyeConfig> configs = new ConcurrentHashMap<LaunchMode, SmallRyeConfig>();

    TestConfigProviderResolver() {
    }

    public Config getConfig() {
        return this.resolver.getConfig();
    }

    public Config getConfig(final LaunchMode mode) {
        if (this.classLoader.equals(Thread.currentThread().getContextClassLoader())) {
            this.resolver.releaseConfig(this.classLoader);
            SmallRyeConfig config = this.configs.computeIfAbsent(mode, new Function<LaunchMode, SmallRyeConfig>(){

                @Override
                public SmallRyeConfig apply(LaunchMode launchMode) {
                    LaunchMode current = LaunchMode.current();
                    LaunchMode.set((LaunchMode)launchMode);
                    SmallRyeConfig config = ConfigUtils.configBuilder((boolean)false, (boolean)true, (LaunchMode)mode).withCustomizers(new SmallRyeConfigBuilderCustomizer[]{new TestConfigCustomizer(mode)}).build();
                    LaunchMode.set((LaunchMode)current);
                    return config;
                }
            });
            this.resolver.registerConfig((Config)config, this.classLoader);
            return config;
        }
        throw new IllegalStateException("Context ClassLoader mismatch. Should be " + String.valueOf(this.classLoader) + " but was " + String.valueOf(Thread.currentThread().getContextClassLoader()));
    }

    public void restoreConfig() {
        if (!this.classLoader.equals(Thread.currentThread().getContextClassLoader())) {
            throw new IllegalStateException("Context ClassLoader mismatch. Should be " + String.valueOf(this.classLoader) + " but was " + String.valueOf(Thread.currentThread().getContextClassLoader()));
        }
        this.resolver.releaseConfig(this.classLoader);
        this.resolver.registerConfig((Config)this.configs.get(LaunchMode.TEST), this.classLoader);
    }

    public void restore() {
        this.configs.clear();
        ConfigProviderResolver.setInstance((ConfigProviderResolver)this.resolver);
    }

    public Config getConfig(ClassLoader loader) {
        return this.resolver.getConfig(loader);
    }

    public SmallRyeConfigBuilder getBuilder() {
        return this.resolver.getBuilder();
    }

    public void registerConfig(Config config, ClassLoader classLoader) {
        this.resolver.registerConfig(config, classLoader);
    }

    public void releaseConfig(Config config) {
        this.resolver.releaseConfig(config);
    }

    public void releaseConfig(ClassLoader classLoader) {
        this.resolver.releaseConfig(classLoader);
    }
}

