/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.junit.mockito.internal;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.ClientProxy;
import io.quarkus.arc.InjectableContext;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.test.InjectMock;
import io.quarkus.test.junit.callback.QuarkusTestAfterAllCallback;
import io.quarkus.test.junit.callback.QuarkusTestAfterConstructCallback;
import io.quarkus.test.junit.callback.QuarkusTestContext;
import io.quarkus.test.junit.mockito.InjectSpy;
import io.quarkus.test.junit.mockito.internal.CreateMockitoMocksCallback;
import io.quarkus.test.junit.mockito.internal.MockitoMocksTracker;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;
import org.mockito.AdditionalAnswers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

public class CreateMockitoSpiesCallback
implements QuarkusTestAfterConstructCallback,
QuarkusTestAfterAllCallback {
    private static final Set<InjectableContext.ContextState> statesToDestroy = new HashSet<InjectableContext.ContextState>();

    public void afterConstruct(Object testInstance) {
        boolean contextPreviouslyActive;
        Class<?> current = testInstance.getClass();
        ArcContainer container = Arc.container();
        boolean bl = contextPreviouslyActive = container != null && container.requestContext().isActive();
        if (!contextPreviouslyActive) {
            statesToDestroy.add(container.requestContext().activate());
        }
        while (current.getSuperclass() != null) {
            for (Field field : current.getDeclaredFields()) {
                InjectSpy injectSpyAnnotation = field.getAnnotation(InjectSpy.class);
                InjectMock injectMockAnnotation = field.getAnnotation(InjectMock.class);
                if (injectSpyAnnotation == null) continue;
                if (injectMockAnnotation != null) {
                    CreateMockitoSpiesCallback.cleanup();
                    throw new IllegalArgumentException("Fields cannot be annotated with both @InjectSpy and @InjectMock. Offending field is '" + field.getDeclaringClass().getName() + "#" + field.getName() + "'");
                }
                InstanceHandle<?> beanHandle = CreateMockitoMocksCallback.getBeanHandle(testInstance, field, InjectSpy.class);
                Object spy = this.createSpyAndSetTestField(testInstance, field, beanHandle, injectSpyAnnotation.delegate());
                MockitoMocksTracker.trackSpy(testInstance, spy, beanHandle.get());
            }
            current = current.getSuperclass();
        }
        if (!contextPreviouslyActive) {
            container.requestContext().deactivate();
        }
    }

    private Object createSpyAndSetTestField(Object testInstance, Field field, InstanceHandle<?> beanHandle, boolean delegate) {
        Object contextualInstance = ClientProxy.unwrap((Object)beanHandle.get());
        Object spy = delegate ? Mockito.mock((Class)beanHandle.getBean().getImplementationClass(), (Answer)AdditionalAnswers.delegatesTo((Object)contextualInstance)) : Mockito.spy((Object)contextualInstance);
        field.setAccessible(true);
        try {
            field.set(testInstance, spy);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        return spy;
    }

    public void afterAll(QuarkusTestContext context) {
        CreateMockitoSpiesCallback.cleanup();
    }

    private static void cleanup() {
        if (!statesToDestroy.isEmpty()) {
            for (InjectableContext.ContextState state : statesToDestroy) {
                Arc.container().requestContext().destroy(state);
            }
            statesToDestroy.clear();
        }
    }
}

