/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.info.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.info.BuildInfo;
import io.quarkus.info.GitInfo;
import io.quarkus.info.JavaInfo;
import io.quarkus.info.OsInfo;
import io.quarkus.info.runtime.JavaInfoContributor;
import io.quarkus.info.runtime.OsInfoContributor;
import io.quarkus.info.runtime.spi.InfoContributor;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.json.Json;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.RoutingContext;
import java.lang.annotation.Annotation;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.jboss.logging.Logger;

@Recorder
public class InfoRecorder {
    private static final Logger log = Logger.getLogger(InfoRecorder.class);

    public RuntimeValue<Map<String, Object>> getFinalInfo(Map<String, Object> buildTimeInfo, List<InfoContributor> knownContributors) {
        HashMap<String, Object> finalBuildInfo = new HashMap<String, Object>(buildTimeInfo);
        for (InfoContributor contributor : knownContributors) {
            String key = contributor.name();
            if (finalBuildInfo.containsKey(key)) {
                log.warn((Object)("Info key " + key + " contains duplicate values. This can lead to unpredictable values being used"));
            }
            finalBuildInfo.put(key, contributor.data());
        }
        for (InstanceHandle handler : Arc.container().listAll(InfoContributor.class, new Annotation[0])) {
            InfoContributor contributor = (InfoContributor)handler.get();
            String key = contributor.name();
            if (finalBuildInfo.containsKey(key)) {
                log.warn((Object)("Info key " + key + " contains duplicate values. This can lead to unpredictable values being used"));
            }
            finalBuildInfo.put(key, contributor.data());
        }
        return new RuntimeValue(finalBuildInfo);
    }

    public Handler<RoutingContext> handler(RuntimeValue<Map<String, Object>> finalBuildInfo) {
        return new InfoHandler((Map)finalBuildInfo.getValue());
    }

    public Supplier<GitInfo> gitInfoSupplier(final String branch, final String latestCommitId, final String latestCommitTime) {
        return new Supplier<GitInfo>(){

            @Override
            public GitInfo get() {
                return new GitInfo(){

                    @Override
                    public String branch() {
                        return branch;
                    }

                    @Override
                    public String latestCommitId() {
                        return latestCommitId;
                    }

                    @Override
                    public OffsetDateTime commitTime() {
                        return OffsetDateTime.parse(latestCommitTime, DateTimeFormatter.ISO_OFFSET_DATE_TIME);
                    }
                };
            }
        };
    }

    public Supplier<BuildInfo> buildInfoSupplier(final String group, final String artifact, final String version, final String time, final String quarkusVersion) {
        return new Supplier<BuildInfo>(){

            @Override
            public BuildInfo get() {
                return new BuildInfo(){

                    @Override
                    public String group() {
                        return group;
                    }

                    @Override
                    public String artifact() {
                        return artifact;
                    }

                    @Override
                    public String version() {
                        return version;
                    }

                    @Override
                    public OffsetDateTime time() {
                        return OffsetDateTime.parse(time, DateTimeFormatter.ISO_OFFSET_DATE_TIME);
                    }

                    @Override
                    public String quarkusVersion() {
                        return quarkusVersion;
                    }
                };
            }
        };
    }

    public OsInfoContributor osInfoContributor() {
        return new OsInfoContributor();
    }

    public Supplier<OsInfo> osInfoSupplier() {
        return new Supplier<OsInfo>(){

            @Override
            public OsInfo get() {
                return new OsInfo(){

                    @Override
                    public String name() {
                        return OsInfoContributor.getName();
                    }

                    @Override
                    public String version() {
                        return OsInfoContributor.getVersion();
                    }

                    @Override
                    public String architecture() {
                        return OsInfoContributor.getArchitecture();
                    }
                };
            }
        };
    }

    public JavaInfoContributor javaInfoContributor() {
        return new JavaInfoContributor();
    }

    public Supplier<JavaInfo> javaInfoSupplier() {
        return new Supplier<JavaInfo>(){

            @Override
            public JavaInfo get() {
                return new JavaInfo(){

                    @Override
                    public String version() {
                        return JavaInfoContributor.getVersion();
                    }

                    @Override
                    public String vendor() {
                        return JavaInfoContributor.getVendor();
                    }

                    @Override
                    public String vendorVersion() {
                        return JavaInfoContributor.getVendorVersion();
                    }
                };
            }
        };
    }

    private static class InfoHandler
    implements Handler<RoutingContext> {
        private final Map<String, Object> finalBuildInfo;

        public InfoHandler(Map<String, Object> finalBuildInfo) {
            this.finalBuildInfo = finalBuildInfo;
        }

        public void handle(RoutingContext ctx) {
            HttpServerResponse resp = ctx.response();
            resp.headers().set(HttpHeaders.CONTENT_TYPE, (CharSequence)"application/json; charset=UTF-8");
            JsonObject jsonObject = new JsonObject(this.finalBuildInfo);
            ctx.end(Json.encodePrettily((Object)jsonObject));
        }
    }
}

