/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.info.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.info.BuildInfo;
import io.quarkus.info.GitInfo;
import io.quarkus.info.JavaInfo;
import io.quarkus.info.OsInfo;
import io.quarkus.info.runtime.JavaInfoContributor;
import io.quarkus.info.runtime.OsInfoContributor;
import io.quarkus.info.runtime.spi.InfoContributor;
import io.quarkus.runtime.annotations.Recorder;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.json.Json;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.RoutingContext;
import java.lang.annotation.Annotation;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

@Recorder
public class InfoRecorder {
    public Handler<RoutingContext> handler(Map<String, Object> buildTimeInfo, List<InfoContributor> knownContributors) {
        return new InfoHandler(buildTimeInfo, knownContributors);
    }

    public Supplier<GitInfo> gitInfoSupplier(final String branch, final String latestCommitId, final String latestCommitTime) {
        return new Supplier<GitInfo>(){

            @Override
            public GitInfo get() {
                return new GitInfo(){

                    @Override
                    public String branch() {
                        return branch;
                    }

                    @Override
                    public String latestCommitId() {
                        return latestCommitId;
                    }

                    @Override
                    public OffsetDateTime commitTime() {
                        return OffsetDateTime.parse(latestCommitTime, DateTimeFormatter.ISO_OFFSET_DATE_TIME);
                    }
                };
            }
        };
    }

    public Supplier<BuildInfo> buildInfoSupplier(final String group, final String artifact, final String version, final String time, final String quarkusVersion) {
        return new Supplier<BuildInfo>(){

            @Override
            public BuildInfo get() {
                return new BuildInfo(){

                    @Override
                    public String group() {
                        return group;
                    }

                    @Override
                    public String artifact() {
                        return artifact;
                    }

                    @Override
                    public String version() {
                        return version;
                    }

                    @Override
                    public OffsetDateTime time() {
                        return OffsetDateTime.parse(time, DateTimeFormatter.ISO_OFFSET_DATE_TIME);
                    }

                    @Override
                    public String quarkusVersion() {
                        return quarkusVersion;
                    }
                };
            }
        };
    }

    public OsInfoContributor osInfoContributor() {
        return new OsInfoContributor();
    }

    public Supplier<OsInfo> osInfoSupplier() {
        return new Supplier<OsInfo>(){

            @Override
            public OsInfo get() {
                return new OsInfo(){

                    @Override
                    public String name() {
                        return OsInfoContributor.getName();
                    }

                    @Override
                    public String version() {
                        return OsInfoContributor.getVersion();
                    }

                    @Override
                    public String architecture() {
                        return OsInfoContributor.getArchitecture();
                    }
                };
            }
        };
    }

    public JavaInfoContributor javaInfoContributor() {
        return new JavaInfoContributor();
    }

    public Supplier<JavaInfo> javaInfoSupplier() {
        return new Supplier<JavaInfo>(){

            @Override
            public JavaInfo get() {
                return new JavaInfo(){

                    @Override
                    public String version() {
                        return JavaInfoContributor.getVersion();
                    }
                };
            }
        };
    }

    private static class InfoHandler
    implements Handler<RoutingContext> {
        private final Map<String, Object> finalBuildInfo;

        public InfoHandler(Map<String, Object> buildTimeInfo, List<InfoContributor> knownContributors) {
            this.finalBuildInfo = new HashMap<String, Object>(buildTimeInfo);
            for (InfoContributor contributor : knownContributors) {
                this.finalBuildInfo.put(contributor.name(), contributor.data());
            }
            for (InstanceHandle handler : Arc.container().listAll(InfoContributor.class, new Annotation[0])) {
                InfoContributor contributor = (InfoContributor)handler.get();
                this.finalBuildInfo.put(contributor.name(), contributor.data());
            }
        }

        public void handle(RoutingContext ctx) {
            HttpServerResponse resp = ctx.response();
            resp.headers().set(HttpHeaders.CONTENT_TYPE, (CharSequence)"application/json; charset=UTF-8");
            JsonObject jsonObject = new JsonObject(this.finalBuildInfo);
            ctx.end(Json.encodePrettily((Object)jsonObject));
        }
    }
}

