/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.reactive.runtime;

import io.quarkus.arc.DefaultBean;
import io.quarkus.arc.Unremovable;
import io.quarkus.hibernate.orm.runtime.JPAConfig;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.Typed;
import javax.inject.Inject;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceUnit;
import org.hibernate.reactive.common.spi.MutinyImplementor;
import org.hibernate.reactive.mutiny.Mutiny;
import org.hibernate.reactive.mutiny.impl.MutinySessionFactoryImpl;

public class ReactiveSessionFactoryProducer {
    @Inject
    @PersistenceUnit
    EntityManagerFactory emf;
    @Inject
    JPAConfig jpaConfig;

    @Produces
    @ApplicationScoped
    @DefaultBean
    @Unremovable
    @Typed(value={Mutiny.SessionFactory.class, MutinyImplementor.class})
    public MutinySessionFactoryImpl mutinySessionFactory() {
        if (this.jpaConfig.getDeactivatedPersistenceUnitNames().contains("default-reactive")) {
            throw new IllegalStateException("Cannot retrieve the Mutiny.SessionFactory for persistence unit default-reactive: Hibernate Reactive was deactivated through configuration properties");
        }
        return (MutinySessionFactoryImpl)this.emf.unwrap(Mutiny.SessionFactory.class);
    }
}

