/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.reactive.panache;

import io.quarkus.hibernate.reactive.panache.PanacheQuery;
import io.quarkus.hibernate.reactive.panache.runtime.JpaOperations;
import io.quarkus.panache.common.Parameters;
import io.quarkus.panache.common.Sort;
import io.quarkus.panache.common.impl.GenerateBridge;
import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.persistence.LockModeType;
import org.hibernate.reactive.mutiny.Mutiny;

public interface PanacheRepositoryBase<Entity, Id> {
    default public Uni<Mutiny.Session> getSession() {
        return JpaOperations.INSTANCE.getSession();
    }

    @CheckReturnValue
    default public Uni<Entity> persist(Entity entity) {
        return JpaOperations.INSTANCE.persist(entity).map(v -> entity);
    }

    @CheckReturnValue
    default public Uni<Entity> persistAndFlush(Entity entity) {
        return JpaOperations.INSTANCE.persist(entity).flatMap(v -> JpaOperations.INSTANCE.flush()).map(v -> entity);
    }

    @CheckReturnValue
    default public Uni<Void> delete(Entity entity) {
        return JpaOperations.INSTANCE.delete(entity);
    }

    default public boolean isPersistent(Entity entity) {
        return JpaOperations.INSTANCE.isPersistent(entity);
    }

    @CheckReturnValue
    default public Uni<Void> flush() {
        return JpaOperations.INSTANCE.flush();
    }

    @CheckReturnValue
    @GenerateBridge
    default public Uni<Entity> findById(Id id) {
        throw JpaOperations.INSTANCE.implementationInjectionMissing();
    }

    @CheckReturnValue
    @GenerateBridge
    default public Uni<Entity> findById(Id id, LockModeType lockModeType) {
        throw JpaOperations.INSTANCE.implementationInjectionMissing();
    }

    @GenerateBridge
    default public PanacheQuery<Entity> find(String query, Object ... params) {
        throw JpaOperations.INSTANCE.implementationInjectionMissing();
    }

    @GenerateBridge
    default public PanacheQuery<Entity> find(String query, Sort sort, Object ... params) {
        throw JpaOperations.INSTANCE.implementationInjectionMissing();
    }

    @GenerateBridge
    default public PanacheQuery<Entity> find(String query, Map<String, Object> params) {
        throw JpaOperations.INSTANCE.implementationInjectionMissing();
    }

    @GenerateBridge
    default public PanacheQuery<Entity> find(String query, Sort sort, Map<String, Object> params) {
        throw JpaOperations.INSTANCE.implementationInjectionMissing();
    }

    @GenerateBridge
    default public PanacheQuery<Entity> find(String query, Parameters params) {
        throw JpaOperations.INSTANCE.implementationInjectionMissing();
    }

    @GenerateBridge
    default public PanacheQuery<Entity> find(String query, Sort sort, Parameters params) {
        throw JpaOperations.INSTANCE.implementationInjectionMissing();
    }

    @GenerateBridge
    default public PanacheQuery<Entity> findAll() {
        throw JpaOperations.INSTANCE.implementationInjectionMissing();
    }

    @GenerateBridge
    default public PanacheQuery<Entity> findAll(Sort sort) {
        throw JpaOperations.INSTANCE.implementationInjectionMissing();
    }

    @CheckReturnValue
    @GenerateBridge
    default public Uni<List<Entity>> list(String query, Object ... params) {
        throw JpaOperations.INSTANCE.implementationInjectionMissing();
    }

    @CheckReturnValue
    @GenerateBridge
    default public Uni<List<Entity>> list(String query, Sort sort, Object ... params) {
        throw JpaOperations.INSTANCE.implementationInjectionMissing();
    }

    @CheckReturnValue
    @GenerateBridge
    default public Uni<List<Entity>> list(String query, Map<String, Object> params) {
        throw JpaOperations.INSTANCE.implementationInjectionMissing();
    }

    @CheckReturnValue
    @GenerateBridge
    default public Uni<List<Entity>> list(String query, Sort sort, Map<String, Object> params) {
        throw JpaOperations.INSTANCE.implementationInjectionMissing();
    }

    @CheckReturnValue
    @GenerateBridge
    default public Uni<List<Entity>> list(String query, Parameters params) {
        throw JpaOperations.INSTANCE.implementationInjectionMissing();
    }

    @CheckReturnValue
    @GenerateBridge
    default public Uni<List<Entity>> list(String query, Sort sort, Parameters params) {
        throw JpaOperations.INSTANCE.implementationInjectionMissing();
    }

    @CheckReturnValue
    @GenerateBridge
    default public Uni<List<Entity>> listAll() {
        throw JpaOperations.INSTANCE.implementationInjectionMissing();
    }

    @CheckReturnValue
    @GenerateBridge
    default public Uni<List<Entity>> listAll(Sort sort) {
        throw JpaOperations.INSTANCE.implementationInjectionMissing();
    }

    @CheckReturnValue
    @GenerateBridge
    default public Multi<Entity> stream(String query, Object ... params) {
        throw JpaOperations.INSTANCE.implementationInjectionMissing();
    }

    @CheckReturnValue
    @GenerateBridge
    default public Multi<Entity> stream(String query, Sort sort, Object ... params) {
        throw JpaOperations.INSTANCE.implementationInjectionMissing();
    }

    @CheckReturnValue
    @GenerateBridge
    default public Multi<Entity> stream(String query, Map<String, Object> params) {
        throw JpaOperations.INSTANCE.implementationInjectionMissing();
    }

    @CheckReturnValue
    @GenerateBridge
    default public Multi<Entity> stream(String query, Sort sort, Map<String, Object> params) {
        throw JpaOperations.INSTANCE.implementationInjectionMissing();
    }

    @CheckReturnValue
    @GenerateBridge
    default public Multi<Entity> stream(String query, Parameters params) {
        throw JpaOperations.INSTANCE.implementationInjectionMissing();
    }

    @CheckReturnValue
    @GenerateBridge
    default public Multi<Entity> stream(String query, Sort sort, Parameters params) {
        throw JpaOperations.INSTANCE.implementationInjectionMissing();
    }

    @CheckReturnValue
    @GenerateBridge
    default public Multi<Entity> streamAll(Sort sort) {
        throw JpaOperations.INSTANCE.implementationInjectionMissing();
    }

    @CheckReturnValue
    @GenerateBridge
    default public Multi<Entity> streamAll() {
        throw JpaOperations.INSTANCE.implementationInjectionMissing();
    }

    @CheckReturnValue
    @GenerateBridge
    default public Uni<Long> count() {
        throw JpaOperations.INSTANCE.implementationInjectionMissing();
    }

    @CheckReturnValue
    @GenerateBridge
    default public Uni<Long> count(String query, Object ... params) {
        throw JpaOperations.INSTANCE.implementationInjectionMissing();
    }

    @CheckReturnValue
    @GenerateBridge
    default public Uni<Long> count(String query, Map<String, Object> params) {
        throw JpaOperations.INSTANCE.implementationInjectionMissing();
    }

    @CheckReturnValue
    @GenerateBridge
    default public Uni<Long> count(String query, Parameters params) {
        throw JpaOperations.INSTANCE.implementationInjectionMissing();
    }

    @CheckReturnValue
    @GenerateBridge
    default public Uni<Long> deleteAll() {
        throw JpaOperations.INSTANCE.implementationInjectionMissing();
    }

    @CheckReturnValue
    @GenerateBridge
    default public Uni<Boolean> deleteById(Id id) {
        throw JpaOperations.INSTANCE.implementationInjectionMissing();
    }

    @CheckReturnValue
    @GenerateBridge
    default public Uni<Long> delete(String query, Object ... params) {
        throw JpaOperations.INSTANCE.implementationInjectionMissing();
    }

    @CheckReturnValue
    @GenerateBridge
    default public Uni<Long> delete(String query, Map<String, Object> params) {
        throw JpaOperations.INSTANCE.implementationInjectionMissing();
    }

    @CheckReturnValue
    @GenerateBridge
    default public Uni<Long> delete(String query, Parameters params) {
        throw JpaOperations.INSTANCE.implementationInjectionMissing();
    }

    @CheckReturnValue
    default public Uni<Void> persist(Iterable<Entity> entities) {
        return JpaOperations.INSTANCE.persist(entities);
    }

    @CheckReturnValue
    default public Uni<Void> persist(Stream<Entity> entities) {
        return JpaOperations.INSTANCE.persist(entities);
    }

    @CheckReturnValue
    default public Uni<Void> persist(Entity firstEntity, Entity ... entities) {
        return JpaOperations.INSTANCE.persist(firstEntity, entities);
    }

    @CheckReturnValue
    @GenerateBridge
    default public Uni<Integer> update(String query, Object ... params) {
        throw JpaOperations.INSTANCE.implementationInjectionMissing();
    }

    @CheckReturnValue
    @GenerateBridge
    default public Uni<Integer> update(String query, Map<String, Object> params) {
        throw JpaOperations.INSTANCE.implementationInjectionMissing();
    }

    @CheckReturnValue
    @GenerateBridge
    default public Uni<Integer> update(String query, Parameters params) {
        throw JpaOperations.INSTANCE.implementationInjectionMissing();
    }
}

