/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.panache;

import io.quarkus.hibernate.orm.panache.PanacheEntityBase;
import io.quarkus.hibernate.orm.panache.PanacheQuery;
import io.quarkus.hibernate.orm.panache.common.runtime.AbstractJpaOperations;
import io.quarkus.hibernate.orm.panache.runtime.JpaOperations;
import io.quarkus.panache.common.Parameters;
import io.quarkus.panache.common.Sort;
import io.quarkus.panache.common.impl.GenerateBridge;
import jakarta.persistence.EntityManager;
import jakarta.persistence.LockModeType;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.hibernate.Session;

public interface PanacheRepositoryBase<Entity, Id> {
    @GenerateBridge
    default public EntityManager getEntityManager() {
        throw AbstractJpaOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public Session getSession() {
        throw AbstractJpaOperations.implementationInjectionMissing();
    }

    default public void persist(Entity entity) {
        JpaOperations.INSTANCE.persist(entity);
    }

    default public void persistAndFlush(Entity entity) {
        JpaOperations.INSTANCE.persist(entity);
        JpaOperations.INSTANCE.flush(entity);
    }

    default public void delete(Entity entity) {
        JpaOperations.INSTANCE.delete(entity);
    }

    default public boolean isPersistent(Entity entity) {
        return JpaOperations.INSTANCE.isPersistent(entity);
    }

    default public void flush() {
        this.getSession().flush();
    }

    @GenerateBridge(targetReturnTypeErased=true)
    default public Entity findById(Id id) {
        throw AbstractJpaOperations.implementationInjectionMissing();
    }

    @GenerateBridge(targetReturnTypeErased=true)
    default public Entity findById(Id id, LockModeType lockModeType) {
        throw AbstractJpaOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public Optional<Entity> findByIdOptional(Id id) {
        throw AbstractJpaOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public Optional<Entity> findByIdOptional(Id id, LockModeType lockModeType) {
        throw AbstractJpaOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public <T extends PanacheEntityBase> List<T> findByIds(List<?> ids) {
        throw JpaOperations.INSTANCE.implementationInjectionMissing();
    }

    @GenerateBridge
    default public PanacheQuery<Entity> find(String query, Object ... params) {
        throw AbstractJpaOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public PanacheQuery<Entity> find(String query, Sort sort, Object ... params) {
        throw AbstractJpaOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public PanacheQuery<Entity> find(String query, Map<String, Object> params) {
        throw AbstractJpaOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public PanacheQuery<Entity> find(String query, Sort sort, Map<String, Object> params) {
        throw AbstractJpaOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public PanacheQuery<Entity> find(String query, Parameters params) {
        throw AbstractJpaOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public PanacheQuery<Entity> find(String query, Sort sort, Parameters params) {
        throw AbstractJpaOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public PanacheQuery<Entity> findAll() {
        throw AbstractJpaOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public PanacheQuery<Entity> findAll(Sort sort) {
        throw AbstractJpaOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public List<Entity> list(String query, Object ... params) {
        throw AbstractJpaOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public List<Entity> list(String query, Sort sort, Object ... params) {
        throw AbstractJpaOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public List<Entity> list(String query, Map<String, Object> params) {
        throw AbstractJpaOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public List<Entity> list(String query, Sort sort, Map<String, Object> params) {
        throw AbstractJpaOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public List<Entity> list(String query, Parameters params) {
        throw AbstractJpaOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public List<Entity> list(String query, Sort sort, Parameters params) {
        throw AbstractJpaOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public List<Entity> listAll() {
        throw AbstractJpaOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public List<Entity> listAll(Sort sort) {
        throw AbstractJpaOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public Stream<Entity> stream(String query, Object ... params) {
        throw AbstractJpaOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public Stream<Entity> stream(String query, Sort sort, Object ... params) {
        throw AbstractJpaOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public Stream<Entity> stream(String query, Map<String, Object> params) {
        throw AbstractJpaOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public Stream<Entity> stream(String query, Sort sort, Map<String, Object> params) {
        throw AbstractJpaOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public Stream<Entity> stream(String query, Parameters params) {
        throw AbstractJpaOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public Stream<Entity> stream(String query, Sort sort, Parameters params) {
        throw AbstractJpaOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public Stream<Entity> streamAll(Sort sort) {
        throw AbstractJpaOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public Stream<Entity> streamAll() {
        throw AbstractJpaOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public long count() {
        throw AbstractJpaOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public long count(String query, Object ... params) {
        throw AbstractJpaOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public long count(String query, Map<String, Object> params) {
        throw AbstractJpaOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public long count(String query, Parameters params) {
        throw AbstractJpaOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public long deleteAll() {
        throw AbstractJpaOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public boolean deleteById(Id id) {
        throw AbstractJpaOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public long delete(String query, Object ... params) {
        throw AbstractJpaOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public long delete(String query, Map<String, Object> params) {
        throw AbstractJpaOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public long delete(String query, Parameters params) {
        throw AbstractJpaOperations.implementationInjectionMissing();
    }

    default public void persist(Iterable<Entity> entities) {
        JpaOperations.INSTANCE.persist(entities);
    }

    default public void persist(Stream<Entity> entities) {
        JpaOperations.INSTANCE.persist(entities);
    }

    default public void persist(Entity firstEntity, Entity ... entities) {
        JpaOperations.INSTANCE.persist(firstEntity, entities);
    }

    @GenerateBridge
    default public int update(String query, Object ... params) {
        throw AbstractJpaOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public int update(String query, Map<String, Object> params) {
        throw AbstractJpaOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public int update(String query, Parameters params) {
        throw AbstractJpaOperations.implementationInjectionMissing();
    }
}

