/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.panache.runtime;

import io.quarkus.hibernate.orm.panache.PanacheQuery;
import io.quarkus.hibernate.orm.panache.common.runtime.AbstractManagedJpaOperations;
import io.quarkus.hibernate.orm.panache.runtime.CustomCountPanacheQuery;
import io.quarkus.hibernate.orm.panache.runtime.JpaOperations;
import io.quarkus.panache.common.Parameters;
import io.quarkus.panache.common.Sort;
import io.quarkus.panache.hibernate.common.runtime.PanacheJpaUtil;
import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.EntityType;
import jakarta.persistence.metamodel.Metamodel;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.Session;
import org.hibernate.engine.spi.CascadeStyle;
import org.hibernate.engine.spi.CascadingActions;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.metamodel.model.domain.internal.EntityTypeImpl;
import org.hibernate.query.CommonQueryContract;
import org.hibernate.query.SelectionQuery;

public class AdditionalJpaOperations {
    public static PanacheQuery<?> find(AbstractManagedJpaOperations<?> jpaOperations, Class<?> entityClass, String query, String countQuery, Sort sort, Map<String, Object> params) {
        String findQuery = PanacheJpaUtil.createFindQuery(entityClass, (String)query, (int)jpaOperations.paramCount(params));
        Session session = jpaOperations.getSession(entityClass);
        SelectionQuery hibernateQuery = session.createSelectionQuery((String)(sort != null ? findQuery + PanacheJpaUtil.toOrderBy((Sort)sort) : findQuery));
        JpaOperations.bindParameters((CommonQueryContract)hibernateQuery, params);
        return new CustomCountPanacheQuery(session, hibernateQuery, countQuery, params);
    }

    public static PanacheQuery<?> find(AbstractManagedJpaOperations<?> jpaOperations, Class<?> entityClass, String query, String countQuery, Sort sort, Parameters parameters) {
        return AdditionalJpaOperations.find(jpaOperations, entityClass, query, countQuery, sort, parameters.map());
    }

    public static PanacheQuery<?> find(AbstractManagedJpaOperations<?> jpaOperations, Class<?> entityClass, String query, String countQuery, Sort sort, Object ... params) {
        String findQuery = PanacheJpaUtil.createFindQuery(entityClass, (String)query, (int)jpaOperations.paramCount(params));
        Session session = jpaOperations.getSession(entityClass);
        SelectionQuery hibernateQuery = session.createSelectionQuery((String)(sort != null ? findQuery + PanacheJpaUtil.toOrderBy((Sort)sort) : findQuery));
        JpaOperations.bindParameters((CommonQueryContract)hibernateQuery, (Object[])params);
        return new CustomCountPanacheQuery(session, hibernateQuery, countQuery, params);
    }

    public static long deleteAllWithCascade(AbstractManagedJpaOperations<?> jpaOperations, Class<?> entityClass) {
        Session session = jpaOperations.getSession(entityClass);
        if (AdditionalJpaOperations.deleteOnCascadeDetected(jpaOperations, entityClass)) {
            int count = 0;
            List objects = jpaOperations.listAll(entityClass);
            for (Object entity : objects) {
                session.remove(entity);
                ++count;
            }
            return count;
        }
        return jpaOperations.deleteAll(entityClass);
    }

    private static boolean deleteOnCascadeDetected(AbstractManagedJpaOperations<?> jpaOperations, Class<?> entityClass) {
        Session session = jpaOperations.getSession(entityClass);
        Metamodel metamodel = session.getMetamodel();
        EntityType entity1 = metamodel.entity(entityClass);
        Set declaredAttributes = ((EntityTypeImpl)entity1).getDeclaredAttributes();
        CascadeStyle[] propertyCascadeStyles = ((SessionImplementor)session.unwrap(SessionImplementor.class)).getEntityPersister(entityClass.getName(), null).getPropertyCascadeStyles();
        boolean doCascade = Arrays.stream(propertyCascadeStyles).anyMatch(cascadeStyle -> cascadeStyle.doCascade(CascadingActions.DELETE));
        boolean hasElementCollection = declaredAttributes.stream().anyMatch(attribute -> attribute.getPersistentAttributeType().equals((Object)Attribute.PersistentAttributeType.ELEMENT_COLLECTION));
        return doCascade || hasElementCollection;
    }

    public static <PanacheQueryType> long deleteWithCascade(AbstractManagedJpaOperations<PanacheQueryType> jpaOperations, Class<?> entityClass, String query, Object ... params) {
        Session session = jpaOperations.getSession(entityClass);
        if (AdditionalJpaOperations.deleteOnCascadeDetected(jpaOperations, entityClass)) {
            int count = 0;
            List objects = jpaOperations.list(jpaOperations.find(entityClass, query, params));
            for (Object entity : objects) {
                session.remove(entity);
                ++count;
            }
            return count;
        }
        return jpaOperations.delete(entityClass, query, params);
    }

    public static <PanacheQueryType> long deleteWithCascade(AbstractManagedJpaOperations<PanacheQueryType> jpaOperations, Class<?> entityClass, String query, Map<String, Object> params) {
        Session session = jpaOperations.getSession(entityClass);
        if (AdditionalJpaOperations.deleteOnCascadeDetected(jpaOperations, entityClass)) {
            int count = 0;
            List objects = jpaOperations.list(jpaOperations.find(entityClass, query, params));
            for (Object entity : objects) {
                session.remove(entity);
                ++count;
            }
            return count;
        }
        return jpaOperations.delete(entityClass, query, params);
    }

    public static long deleteWithCascade(AbstractManagedJpaOperations<?> jpaOperations, Class<?> entityClass, String query, Parameters params) {
        return AdditionalJpaOperations.deleteWithCascade(jpaOperations, entityClass, query, params.map());
    }
}

