/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.dev;

import io.quarkus.hibernate.orm.dev.HibernateOrmDevInfo;
import io.quarkus.hibernate.orm.runtime.boot.QuarkusPersistenceUnitDescriptor;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.function.Supplier;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.query.NamedHqlQueryDefinition;
import org.hibernate.boot.query.NamedNativeQueryDefinition;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.tool.schema.Action;
import org.hibernate.tool.schema.SourceType;
import org.hibernate.tool.schema.TargetType;
import org.hibernate.tool.schema.internal.ExceptionHandlerCollectingImpl;
import org.hibernate.tool.schema.internal.HibernateSchemaManagementTool;
import org.hibernate.tool.schema.internal.exec.ScriptTargetOutputToWriter;
import org.hibernate.tool.schema.spi.ContributableMatcher;
import org.hibernate.tool.schema.spi.ExceptionHandler;
import org.hibernate.tool.schema.spi.ExecutionOptions;
import org.hibernate.tool.schema.spi.SchemaCreator;
import org.hibernate.tool.schema.spi.SchemaDropper;
import org.hibernate.tool.schema.spi.SchemaManagementTool;
import org.hibernate.tool.schema.spi.SchemaManagementToolCoordinator;
import org.hibernate.tool.schema.spi.SchemaMigrator;
import org.hibernate.tool.schema.spi.ScriptSourceInput;
import org.hibernate.tool.schema.spi.ScriptTargetOutput;
import org.hibernate.tool.schema.spi.SourceDescriptor;
import org.hibernate.tool.schema.spi.TargetDescriptor;

public class HibernateOrmDevController {
    private static final HibernateOrmDevController INSTANCE = new HibernateOrmDevController();
    private HibernateOrmDevInfo info = new HibernateOrmDevInfo();

    public static HibernateOrmDevController get() {
        return INSTANCE;
    }

    private HibernateOrmDevController() {
    }

    public HibernateOrmDevInfo getInfo() {
        return this.info;
    }

    void pushPersistenceUnit(SessionFactoryImplementor sessionFactoryImplementor, QuarkusPersistenceUnitDescriptor descriptor, String persistenceUnitName, Metadata metadata, ServiceRegistry serviceRegistry, String importFile) {
        ArrayList<HibernateOrmDevInfo.Entity> managedEntities = new ArrayList<HibernateOrmDevInfo.Entity>();
        for (PersistentClass entityBinding : metadata.getEntityBindings()) {
            managedEntities.add(new HibernateOrmDevInfo.Entity(entityBinding.getJpaEntityName(), entityBinding.getClassName(), entityBinding.getTable().getName()));
        }
        managedEntities.sort(Comparator.comparing(HibernateOrmDevInfo.Entity::getName));
        ArrayList<HibernateOrmDevInfo.Query> namedQueries = new ArrayList<HibernateOrmDevInfo.Query>();
        ArrayList namedQueriesHqlDefs = new ArrayList();
        metadata.visitNamedHqlQueryDefinitions(namedQueriesHqlDefs::add);
        for (Object queryDefinition : namedQueriesHqlDefs) {
            namedQueries.add(new HibernateOrmDevInfo.Query((NamedHqlQueryDefinition)queryDefinition));
        }
        namedQueries.sort(Comparator.comparing(HibernateOrmDevInfo.Query::getName));
        ArrayList<HibernateOrmDevInfo.Query> namedNativeQueries = new ArrayList<HibernateOrmDevInfo.Query>();
        ArrayList namedNativeQueriesNativeDefs = new ArrayList();
        metadata.visitNamedNativeQueryDefinitions(namedNativeQueriesNativeDefs::add);
        for (NamedNativeQueryDefinition staticQueryDefinition : namedNativeQueriesNativeDefs) {
            namedNativeQueries.add(new HibernateOrmDevInfo.Query(staticQueryDefinition));
        }
        DDLSupplier createDDLSupplier = new DDLSupplier(Action.CREATE, metadata, serviceRegistry, importFile);
        DDLSupplier dropDDLSupplier = new DDLSupplier(Action.DROP, metadata, serviceRegistry, importFile);
        DDLSupplier updateDDLSupplier = new DDLSupplier(Action.UPDATE, metadata, serviceRegistry, importFile);
        this.info.add(new HibernateOrmDevInfo.PersistenceUnit(sessionFactoryImplementor, persistenceUnitName, managedEntities, namedQueries, namedNativeQueries, createDDLSupplier, dropDDLSupplier, updateDDLSupplier, descriptor.isReactive()));
    }

    void clearData() {
        this.info = new HibernateOrmDevInfo();
    }

    private static String generateDDL(Action action, Metadata metadata, ServiceRegistry ssr, String importFiles) {
        HibernateSchemaManagementTool tool = (HibernateSchemaManagementTool)ssr.getService(SchemaManagementTool.class);
        HashMap<String, Object> config = new HashMap<String, Object>(((ConfigurationService)ssr.getService(ConfigurationService.class)).getSettings());
        config.put("hibernate.hbm2ddl.delimiter", ";");
        config.put("hibernate.format_sql", true);
        config.put("jakarta.persistence.sql-load-script-source", importFiles);
        ExceptionHandlerCollectingImpl exceptionHandler = new ExceptionHandlerCollectingImpl();
        try {
            ExecutionOptions executionOptions = SchemaManagementToolCoordinator.buildExecutionOptions(config, (ExceptionHandler)exceptionHandler);
            final StringWriter writer = new StringWriter();
            SourceDescriptor source = new SourceDescriptor(){

                public SourceType getSourceType() {
                    return SourceType.METADATA;
                }

                public ScriptSourceInput getScriptSourceInput() {
                    return null;
                }
            };
            TargetDescriptor target = new TargetDescriptor(){

                public EnumSet<TargetType> getTargetTypes() {
                    return EnumSet.of(TargetType.SCRIPT);
                }

                public ScriptTargetOutput getScriptTargetOutput() {
                    return new ScriptTargetOutputToWriter(writer){

                        public void accept(String command) {
                            super.accept(command);
                        }
                    };
                }
            };
            if (action == Action.DROP) {
                SchemaDropper schemaDropper = tool.getSchemaDropper(executionOptions.getConfigurationValues());
                schemaDropper.doDrop(metadata, executionOptions, ContributableMatcher.ALL, source, target);
            } else if (action == Action.CREATE) {
                SchemaCreator schemaCreator = tool.getSchemaCreator(executionOptions.getConfigurationValues());
                schemaCreator.doCreation(metadata, executionOptions, ContributableMatcher.ALL, source, target);
            } else if (action == Action.UPDATE) {
                SchemaMigrator schemaMigrator = tool.getSchemaMigrator(executionOptions.getConfigurationValues());
                schemaMigrator.doMigration(metadata, executionOptions, ContributableMatcher.ALL, target);
            }
            return writer.toString();
        }
        catch (RuntimeException e) {
            StringWriter stackTraceWriter = new StringWriter();
            e.printStackTrace(new PrintWriter(stackTraceWriter));
            return "Could not generate DDL: \n" + stackTraceWriter.toString();
        }
    }

    class DDLSupplier
    implements Supplier<String> {
        private final Action action;
        private final Metadata metadata;
        private final ServiceRegistry serviceRegistry;
        private final String importFile;

        DDLSupplier(Action action, Metadata metadata, ServiceRegistry serviceRegistry, String importFile) {
            this.action = action;
            this.metadata = metadata;
            this.serviceRegistry = serviceRegistry;
            this.importFile = importFile;
        }

        @Override
        public String get() {
            return HibernateOrmDevController.generateDDL(this.action, this.metadata, this.serviceRegistry, this.importFile);
        }
    }
}

