/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.deployment;

import io.quarkus.hibernate.orm.deployment.MySQLDialectConfig;
import io.quarkus.hibernate.orm.deployment.OracleDialectConfig;
import io.quarkus.hibernate.orm.deployment.SqlServerDialectConfig;
import io.quarkus.runtime.annotations.ConfigDocDefault;
import io.quarkus.runtime.annotations.ConfigDocIgnore;
import io.quarkus.runtime.annotations.ConfigDocMapKey;
import io.quarkus.runtime.annotations.ConfigDocSection;
import io.quarkus.runtime.annotations.ConfigGroup;
import io.quarkus.runtime.configuration.TrimmedStringConverter;
import io.smallrye.config.WithConverter;
import io.smallrye.config.WithDefault;
import io.smallrye.config.WithName;
import io.smallrye.config.WithParentName;
import java.nio.charset.Charset;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import org.hibernate.annotations.TimeZoneStorageType;
import org.hibernate.id.enhanced.StandardOptimizerDescriptor;

@ConfigGroup
public interface HibernateOrmConfigPersistenceUnit {
    public Optional<@WithConverter(value=TrimmedStringConverter.class) String> datasource();

    public Optional<Set<@WithConverter(value=TrimmedStringConverter.class) String>> packages();

    @ConfigDocSection
    public HibernateOrmConfigPersistenceUnitDialect dialect();

    @ConfigDocDefault(value="import.sql in dev and test modes ; no-file otherwise")
    public Optional<List<@WithConverter(value=TrimmedStringConverter.class) String>> sqlLoadScript();

    @ConfigDocDefault(value="16")
    @Deprecated
    public OptionalInt batchFetchSize();

    @Deprecated
    public OptionalInt maxFetchDepth();

    public Optional<@WithConverter(value=TrimmedStringConverter.class) String> physicalNamingStrategy();

    public Optional<@WithConverter(value=TrimmedStringConverter.class) String> implicitNamingStrategy();

    public Optional<@WithConverter(value=TrimmedStringConverter.class) String> metadataBuilderContributor();

    @ConfigDocDefault(value="META-INF/orm.xml if it exists; no-file otherwise")
    public Optional<Set<@WithConverter(value=TrimmedStringConverter.class) String>> mappingFiles();

    @ConfigDocSection
    public HibernateOrmConfigPersistenceUnitMapping mapping();

    @ConfigDocSection
    public HibernateOrmConfigPersistenceUnitQuery query();

    @ConfigDocSection
    public HibernateOrmConfigPersistenceUnitDatabase database();

    @ConfigDocSection
    public HibernateOrmConfigPersistenceUnitJdbc jdbc();

    @ConfigDocSection
    public HibernateOrmConfigPersistenceUnitFetch fetch();

    @ConfigDocSection
    public Map<String, HibernateOrmConfigPersistenceUnitCache> cache();

    @ConfigDocSection
    public HibernateOrmConfigPersistenceUnitDiscriminator discriminator();

    public HibernateOrmConfigPersistenceUnitQuoteIdentifiers quoteIdentifiers();

    @WithDefault(value="true")
    public boolean secondLevelCachingEnabled();

    public HibernateOrmConfigPersistenceValidation validation();

    public Optional<@WithConverter(value=TrimmedStringConverter.class) String> multitenant();

    @Deprecated
    public Optional<@WithConverter(value=TrimmedStringConverter.class) String> multitenantSchemaDatasource();

    @WithDefault(value="true")
    public boolean validateInDevMode();

    @ConfigDocIgnore
    @ConfigDocMapKey(value="full-property-key")
    public Map<String, String> unsupportedProperties();

    default public boolean isAnyPropertySet() {
        return this.datasource().isPresent() || this.packages().isPresent() || this.dialect().isAnyPropertySet() || this.sqlLoadScript().isPresent() || this.batchFetchSize().isPresent() || this.maxFetchDepth().isPresent() || this.physicalNamingStrategy().isPresent() || this.implicitNamingStrategy().isPresent() || this.metadataBuilderContributor().isPresent() || this.mapping().isAnyPropertySet() || this.query().isAnyPropertySet() || this.database().isAnyPropertySet() || this.jdbc().isAnyPropertySet() || !this.cache().isEmpty() || !this.secondLevelCachingEnabled() || this.multitenant().isPresent() || this.multitenantSchemaDatasource().isPresent() || this.fetch().isAnyPropertySet() || this.discriminator().isAnyPropertySet() || this.quoteIdentifiers().isAnyPropertySet() || !this.unsupportedProperties().isEmpty();
    }

    @ConfigGroup
    public static interface HibernateOrmConfigPersistenceUnitDialect {
        @WithParentName
        @ConfigDocDefault(value="selected automatically for most popular databases")
        public Optional<@WithConverter(value=TrimmedStringConverter.class) String> dialect();

        @WithConverter(value=TrimmedStringConverter.class)
        @Deprecated
        public Optional<String> storageEngine();

        public MySQLDialectConfig mariadb();

        public MySQLDialectConfig mysql();

        public OracleDialectConfig oracle();

        public SqlServerDialectConfig mssql();

        default public boolean isAnyPropertySet() {
            return this.dialect().isPresent() || this.storageEngine().isPresent() || this.mysql().isAnyPropertySet() || this.oracle().isAnyPropertySet() || this.mssql().isAnyPropertySet() || this.mariadb().isAnyPropertySet();
        }
    }

    @ConfigGroup
    public static interface HibernateOrmConfigPersistenceUnitMapping {
        public Timezone timezone();

        public Id id();

        public Duration duration();

        @WithName(value="instant.preferred-jdbc-type")
        @ConfigDocDefault(value="TIMESTAMP")
        public Optional<@WithConverter(value=TrimmedStringConverter.class) String> instantPreferredJdbcType();

        @WithName(value="boolean.preferred-jdbc-type")
        @ConfigDocDefault(value="BOOLEAN")
        public Optional<@WithConverter(value=TrimmedStringConverter.class) String> booleanPreferredJdbcType();

        @WithName(value="uuid.preferred-jdbc-type")
        @ConfigDocDefault(value="UUID")
        public Optional<@WithConverter(value=TrimmedStringConverter.class) String> UUIDPreferredJdbcType();

        default public boolean isAnyPropertySet() {
            return this.timezone().timeZoneDefaultStorage().isPresent() || this.id().optimizer().idOptimizerDefault().isPresent() || this.duration().durationPreferredJdbcType().isPresent() || this.instantPreferredJdbcType().isPresent() || this.booleanPreferredJdbcType().isPresent() || this.UUIDPreferredJdbcType().isPresent();
        }

        @ConfigGroup
        public static interface Timezone {
            @WithName(value="default-storage")
            @ConfigDocDefault(value="default")
            public Optional<TimeZoneStorageType> timeZoneDefaultStorage();
        }

        @ConfigGroup
        public static interface Id {
            public Optimizer optimizer();

            @ConfigGroup
            public static interface Optimizer {
                @WithName(value="default")
                @ConfigDocDefault(value="pooled-lo")
                public Optional<IdOptimizerType> idOptimizerDefault();
            }
        }

        @ConfigGroup
        public static interface Duration {
            @WithName(value="preferred-jdbc-type")
            @ConfigDocDefault(value="INTERVAL_SECOND")
            public Optional<@WithConverter(value=TrimmedStringConverter.class) String> durationPreferredJdbcType();
        }
    }

    @ConfigGroup
    public static interface HibernateOrmConfigPersistenceUnitQuery {
        public static final int DEFAULT_QUERY_PLAN_CACHE_MAX_SIZE = 2048;

        @WithDefault(value="2048")
        public int queryPlanCacheMaxSize();

        @WithDefault(value="none")
        public NullOrdering defaultNullOrdering();

        @WithDefault(value="true")
        public boolean inClauseParameterPadding();

        @WithDefault(value="false")
        public boolean failOnPaginationOverCollectionFetch();

        default public boolean isAnyPropertySet() {
            return this.queryPlanCacheMaxSize() != 2048 || this.defaultNullOrdering() != NullOrdering.NONE || !this.inClauseParameterPadding();
        }

        public static enum NullOrdering {
            NONE,
            FIRST,
            LAST;

        }
    }

    @ConfigGroup
    public static interface HibernateOrmConfigPersistenceUnitDatabase {
        public static final String DEFAULT_CHARSET = "UTF-8";

        @WithDefault(value="UTF-8")
        public Charset charset();

        @Deprecated
        @WithDefault(value="false")
        public boolean globallyQuotedIdentifiers();

        default public boolean isAnyPropertySet() {
            return !DEFAULT_CHARSET.equals(this.charset().name()) || this.globallyQuotedIdentifiers();
        }
    }

    @ConfigGroup
    public static interface HibernateOrmConfigPersistenceUnitJdbc {
        public Optional<@WithConverter(value=TrimmedStringConverter.class) String> timezone();

        public OptionalInt statementFetchSize();

        public OptionalInt statementBatchSize();

        default public boolean isAnyPropertySet() {
            return this.timezone().isPresent() || this.statementFetchSize().isPresent() || this.statementBatchSize().isPresent();
        }
    }

    @ConfigGroup
    public static interface HibernateOrmConfigPersistenceUnitFetch {
        @ConfigDocDefault(value="16")
        public OptionalInt batchSize();

        public OptionalInt maxDepth();

        default public boolean isAnyPropertySet() {
            return this.batchSize().isPresent() || this.maxDepth().isPresent();
        }
    }

    @ConfigGroup
    public static interface HibernateOrmConfigPersistenceUnitDiscriminator {
        @WithDefault(value="false")
        public boolean ignoreExplicitForJoined();

        default public boolean isAnyPropertySet() {
            return this.ignoreExplicitForJoined();
        }
    }

    @ConfigGroup
    public static interface HibernateOrmConfigPersistenceUnitQuoteIdentifiers {
        @WithDefault(value="none")
        public IdentifierQuotingStrategy strategy();

        default public boolean isAnyPropertySet() {
            return this.strategy() != IdentifierQuotingStrategy.NONE;
        }
    }

    @ConfigGroup
    public static interface HibernateOrmConfigPersistenceValidation {
        @Deprecated(since="3.19", forRemoval=true)
        @WithDefault(value="true")
        public boolean enabled();

        @WithDefault(value="auto")
        public Set<ValidationMode> mode();

        public static enum ValidationMode {
            AUTO,
            CALLBACK,
            DDL,
            NONE;

        }
    }

    public static enum IdentifierQuotingStrategy {
        NONE,
        ALL,
        ALL_EXCEPT_COLUMN_DEFINITIONS,
        ONLY_KEYWORDS;

    }

    @ConfigGroup
    public static interface HibernateOrmConfigPersistenceUnitCacheMemory {
        public OptionalLong objectCount();
    }

    @ConfigGroup
    public static interface HibernateOrmConfigPersistenceUnitCacheExpiration {
        public Optional<Duration> maxIdle();
    }

    @ConfigGroup
    public static interface HibernateOrmConfigPersistenceUnitCache {
        public HibernateOrmConfigPersistenceUnitCacheExpiration expiration();

        public HibernateOrmConfigPersistenceUnitCacheMemory memory();
    }

    public static enum IdOptimizerType {
        POOLED_LO(StandardOptimizerDescriptor.POOLED_LO),
        POOLED(StandardOptimizerDescriptor.POOLED),
        NONE(StandardOptimizerDescriptor.NONE);

        public final String configName;

        private IdOptimizerType(StandardOptimizerDescriptor delegate) {
            this.configName = delegate.getExternalName();
        }
    }
}

