/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.BuildSteps;
import io.quarkus.deployment.builditem.NativeImageFeatureBuildItem;
import io.quarkus.deployment.logging.LogCleanupFilterBuildItem;
import io.quarkus.deployment.pkg.steps.NativeOrNativeSourcesBuild;
import io.quarkus.hibernate.orm.deployment.HibernateOrmEnabled;
import io.quarkus.hibernate.orm.runtime.graal.DisableLoggingFeature;

@BuildSteps(onlyIf={HibernateOrmEnabled.class})
public final class HibernateLogFilterBuildStep {
    @BuildStep(onlyIf={NativeOrNativeSourcesBuild.class})
    NativeImageFeatureBuildItem nativeImageFeature() {
        return new NativeImageFeatureBuildItem(DisableLoggingFeature.class);
    }

    @BuildStep
    void setupLogFilters(BuildProducer<LogCleanupFilterBuildItem> filters) {
        filters.produce((BuildItem)new LogCleanupFilterBuildItem("org.hibernate.Version", new String[]{"HHH000412"}));
        filters.produce((BuildItem)new LogCleanupFilterBuildItem("org.hibernate.cfg.Environment", new String[]{"HHH000406"}));
        filters.produce((BuildItem)new LogCleanupFilterBuildItem("org.hibernate.jpa.internal.util.LogHelper", new String[]{"HHH000204"}));
        filters.produce((BuildItem)new LogCleanupFilterBuildItem("SQL dialect", new String[]{"HHH000400"}));
        filters.produce((BuildItem)new LogCleanupFilterBuildItem("org.hibernate.orm.beans", new String[]{"HHH10005002", "HHH10005004"}));
        filters.produce((BuildItem)new LogCleanupFilterBuildItem("org.hibernate.orm.incubating", new String[]{"HHH90006001"}));
        filters.produce((BuildItem)new LogCleanupFilterBuildItem("org.hibernate.orm.deprecation", new String[]{"HHH90000025"}));
    }
}

