/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.grpc.runtime.supports.exc;

import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.StatusException;
import io.quarkus.arc.DefaultBean;
import io.quarkus.grpc.ExceptionHandler;
import io.quarkus.grpc.ExceptionHandlerProvider;
import io.quarkus.grpc.auth.AuthExceptionHandlerProvider;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Instance;

@ApplicationScoped
@DefaultBean
public class DefaultExceptionHandlerProvider
implements ExceptionHandlerProvider {
    private final AuthExceptionHandlerProvider authExceptionHandlerProvider;

    public DefaultExceptionHandlerProvider(Instance<AuthExceptionHandlerProvider> authExceptionHandlerProviderInstance) {
        this.authExceptionHandlerProvider = authExceptionHandlerProviderInstance.isResolvable() ? (AuthExceptionHandlerProvider)authExceptionHandlerProviderInstance.get() : null;
    }

    public <ReqT, RespT> ExceptionHandler<ReqT, RespT> createHandler(ServerCall.Listener<ReqT> listener, ServerCall<ReqT, RespT> call, Metadata metadata) {
        return new DefaultExceptionHandler<ReqT, RespT>(listener, call, metadata, this.authExceptionHandlerProvider);
    }

    public Throwable transform(Throwable t) {
        return DefaultExceptionHandlerProvider.toStatusException(this.authExceptionHandlerProvider, t);
    }

    private static Throwable toStatusException(AuthExceptionHandlerProvider authExceptionHandlerProvider, Throwable t) {
        if (authExceptionHandlerProvider != null && authExceptionHandlerProvider.handlesException(t)) {
            return authExceptionHandlerProvider.transformToStatusException(t);
        }
        return ExceptionHandlerProvider.toStatusException((Throwable)t, (boolean)false);
    }

    private static class DefaultExceptionHandler<ReqT, RespT>
    extends ExceptionHandler<ReqT, RespT> {
        private final AuthExceptionHandlerProvider authExceptionHandlerProvider;

        public DefaultExceptionHandler(ServerCall.Listener<ReqT> listener, ServerCall<ReqT, RespT> call, Metadata metadata, AuthExceptionHandlerProvider authExceptionHandlerProvider) {
            super(listener, call, metadata);
            this.authExceptionHandlerProvider = authExceptionHandlerProvider;
        }

        protected void handleException(Throwable exception, ServerCall<ReqT, RespT> call, Metadata metadata) {
            block2: {
                StatusException se = (StatusException)DefaultExceptionHandlerProvider.toStatusException(this.authExceptionHandlerProvider, exception);
                Metadata trailers = se.getTrailers() != null ? se.getTrailers() : metadata;
                try {
                    call.close(se.getStatus(), trailers);
                }
                catch (IllegalStateException ise) {
                    if ("Already closed".equals(ise.getMessage())) break block2;
                    throw ise;
                }
            }
        }
    }
}

