/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.grpc.runtime.supports.context;

import io.grpc.Context;
import io.grpc.ForwardingServerCall;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.Status;
import io.grpc.StatusException;
import io.quarkus.grpc.ExceptionHandlerProvider;
import io.quarkus.grpc.GlobalInterceptor;
import io.quarkus.vertx.core.runtime.context.VertxContextSafetyToggle;
import io.smallrye.common.vertx.VertxContext;
import io.vertx.core.Vertx;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.spi.Prioritized;
import jakarta.inject.Inject;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jboss.logging.Logger;

@ApplicationScoped
@GlobalInterceptor
public class GrpcDuplicatedContextGrpcInterceptor
implements ServerInterceptor,
Prioritized {
    private static final Logger log = Logger.getLogger((String)GrpcDuplicatedContextGrpcInterceptor.class.getName());
    @Inject
    ExceptionHandlerProvider ehp;

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        io.vertx.core.Context capturedVertxContext = Vertx.currentContext();
        if (capturedVertxContext != null) {
            io.vertx.core.Context local = VertxContext.getOrCreateDuplicatedContext((io.vertx.core.Context)capturedVertxContext);
            VertxContextSafetyToggle.setContextSafe((io.vertx.core.Context)local, (boolean)true);
            return new ListenedOnDuplicatedContext<ReqT, RespT>(this.ehp, call, this.nextCall(call, headers, next), local);
        }
        log.warn((Object)"Unable to run on a duplicated context - interceptor not called on the Vert.x event loop");
        return next.startCall(call, headers);
    }

    private <ReqT, RespT> Function<Runnable, ServerCall.Listener<ReqT>> nextCall(final ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        Context current = Context.current();
        return onClose -> {
            Context previous = current.attach();
            try {
                ForwardingServerCall forwardingCall = new ForwardingServerCall<ReqT, RespT>((Runnable)onClose){
                    final /* synthetic */ Runnable val$onClose;
                    {
                        this.val$onClose = runnable;
                    }

                    protected ServerCall<ReqT, RespT> delegate() {
                        return call;
                    }

                    public void close(Status status, Metadata trailers) {
                        this.val$onClose.run();
                        super.close(status, trailers);
                    }
                };
                ServerCall.Listener listener = next.startCall((ServerCall)forwardingCall, headers);
                return listener;
            }
            finally {
                current.detach(previous);
            }
        };
    }

    public int getPriority() {
        return 0x7FFFFFFA;
    }

    static class ListenedOnDuplicatedContext<ReqT, RespT>
    extends ServerCall.Listener<ReqT> {
        private final io.vertx.core.Context context;
        private final Function<Runnable, ServerCall.Listener<ReqT>> listenerCreator;
        private final ExceptionHandlerProvider ehp;
        private final ServerCall<ReqT, RespT> call;
        private volatile ServerCall.Listener<ReqT> delegate;
        private final AtomicBoolean closed = new AtomicBoolean();

        public ListenedOnDuplicatedContext(ExceptionHandlerProvider ehp, ServerCall<ReqT, RespT> call, Function<Runnable, ServerCall.Listener<ReqT>> listenerCreator, io.vertx.core.Context context) {
            this.ehp = ehp;
            this.context = context;
            this.listenerCreator = listenerCreator;
            this.call = call;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ServerCall.Listener<ReqT> getDelegate() {
            if (this.delegate == null && !this.closed.get()) {
                ListenedOnDuplicatedContext listenedOnDuplicatedContext = this;
                synchronized (listenedOnDuplicatedContext) {
                    if (this.delegate == null && !this.closed.get()) {
                        try {
                            this.delegate = this.listenerCreator.apply(() -> this.closed.set(true));
                        }
                        catch (Throwable t) {
                            log.warn((Object)"Unable to retrieve gRPC Server call listener, see the cause below.");
                            this.close(t);
                            return null;
                        }
                    }
                }
            }
            return this.delegate;
        }

        private void close(Throwable t) {
            if (this.closed.compareAndSet(false, true) && this.call.isReady()) {
                Throwable nt = this.ehp.transform(t);
                StatusException sre = (StatusException)ExceptionHandlerProvider.toStatusException((Throwable)nt, (boolean)false);
                Optional metadata = ExceptionHandlerProvider.toTrailers((Throwable)nt);
                log.warn((Object)"Closing gRPC call due to an error ...", t);
                this.call.close(sre.getStatus(), metadata.orElse(new Metadata()));
            }
        }

        private void invoke(Consumer<ServerCall.Listener<ReqT>> invocation) {
            if (Vertx.currentContext() == this.context) {
                ServerCall.Listener<ReqT> listener = this.getDelegate();
                if (listener == null) {
                    return;
                }
                try {
                    invocation.accept(listener);
                }
                catch (Throwable t) {
                    this.close(t);
                }
            } else {
                this.context.runOnContext(v -> {
                    ServerCall.Listener<ReqT> listener = this.getDelegate();
                    if (listener == null) {
                        return;
                    }
                    try {
                        invocation.accept(listener);
                    }
                    catch (Throwable t) {
                        this.close(t);
                    }
                });
            }
        }

        public void onMessage(ReqT message) {
            this.invoke(listener -> listener.onMessage(message));
        }

        public void onReady() {
            this.invoke(ServerCall.Listener::onReady);
        }

        public void onHalfClose() {
            this.invoke(ServerCall.Listener::onHalfClose);
        }

        public void onCancel() {
            this.invoke(ServerCall.Listener::onCancel);
        }

        public void onComplete() {
            this.invoke(ServerCall.Listener::onComplete);
        }
    }
}

